/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.wiki.page.panel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import owmii.powah.Powah;
import owmii.powah.lib.client.screen.Texture;
import owmii.powah.lib.client.screen.widget.IconButton;
import owmii.powah.lib.client.screen.wiki.WikiScreen;
import owmii.powah.lib.client.util.MC;
import owmii.powah.lib.client.wiki.Section;
import owmii.powah.lib.client.wiki.page.panel.Panel;
import owmii.powah.lib.registry.IVariantEntry;
import owmii.powah.lib.registry.VarReg;

public class ItemPanel<T extends ItemLike>
extends Panel {
    private final ItemLike[] items;
    private int currItem;
    private IconButton nextItem = IconButton.EMPTY;
    private IconButton prevItem = IconButton.EMPTY;

    public ItemPanel(Section parent) {
        this(parent.getEntry().getStack().m_41720_(), parent);
    }

    public ItemPanel(T item, Section parent) {
        this(ItemPanel.getSiblings(item), parent);
    }

    public ItemPanel(List<T> items, Section parent) {
        this(items.toArray(new ItemLike[0]), parent);
    }

    public ItemPanel(ItemLike[] items, Section parent) {
        super("", parent);
        this.items = items;
    }

    protected static ItemLike[] getSiblings(ItemLike item) {
        if (item.equals(Items.f_41852_)) {
            return new ItemLike[0];
        }
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)item.m_5456_());
        if (item instanceof IVariantEntry) {
            IVariantEntry variantEntry = (IVariantEntry)item;
            id = new ResourceLocation(id.m_135827_(), id.m_135815_().replace("_" + variantEntry.getVariant().getName(), ""));
        }
        return (ItemLike[])VarReg.getSiblingIds(Objects.requireNonNull(id).m_135815_()).stream().map(rl -> (Item)BuiltInRegistries.f_257033_.m_7745_(Powah.id(rl))).toArray(ItemLike[]::new);
    }

    @Override
    public void init(int x, int y, WikiScreen screen) {
        super.init(x, y, screen);
        this.nextItem = screen.addButton2(new IconButton(x + 139 - 28, y + 26, Texture.WIKI_ITM_NEXT, button -> {
            if (this.currItem < this.items.length - 1) {
                ++this.currItem;
                screen.setPanel(this);
                MC.open(screen);
            }
        }, screen));
        this.prevItem = screen.addButton2(new IconButton(x + 69 - 28, y + 26, Texture.WIKI_ITM_PREV, button -> {
            if (this.currItem > 0) {
                --this.currItem;
                screen.setPanel(this);
                MC.open(screen);
            }
        }, screen));
        this.refresh();
    }

    @Override
    public void refresh() {
        super.refresh();
        this.nextItem.f_93624_ = this.currItem < this.items.length - 1;
        this.prevItem.f_93624_ = this.currItem > 0;
    }

    @Override
    public void render(GuiGraphics gui, int x, int y, int mx, int my, float pt, Font font, WikiScreen screen) {
        ItemStack stack = new ItemStack(this.getItem());
        if (Texture.WIKI_BIG_FRM.isMouseOver(x + 80 - 21, y + 10, mx, my)) {
            screen.hoveredStack = stack;
        }
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x + 4) + 80.5f - 21.0f, (float)(y + 4 + 10), 0.0f);
        RenderSystem.applyModelViewMatrix();
        Texture.WIKI_BIG_FRM.draw(gui, -4, -4);
        poseStack.m_85841_(2.1f, 2.1f, 1.0f);
        gui.m_280203_(stack, 0, 0);
        gui.m_280370_(font, stack, 0, 0);
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        String s = stack.m_41786_().getString();
        gui.m_280056_(font, s, Math.round((float)x + 80.5f - (float)font.m_92895_(s) / 2.0f), y + 61, 2965320, false);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double i) {
        if (i == -1.0 && this.nextItem.f_93624_) {
            this.nextItem.m_5691_();
            return true;
        }
        if (i == 1.0 && this.prevItem.f_93624_) {
            this.prevItem.m_5691_();
            return true;
        }
        return true;
    }

    @Override
    public void onClose() {
        this.currItem = 0;
    }

    public ItemLike getItem() {
        return this.items[this.currItem].m_5456_();
    }
}

