/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.client.models.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.client.models.block_entity.SGJourneyModel;
import net.povstalec.sgjourney.client.render.SGJourneyRenderTypes;
import net.povstalec.sgjourney.client.resourcepack.ResourcepackModel;
import net.povstalec.sgjourney.common.block_entities.stargate.AbstractStargateEntity;
import net.povstalec.sgjourney.common.block_entities.stargate.IrisStargateEntity;
import net.povstalec.sgjourney.common.misc.ColorUtil;
import net.povstalec.sgjourney.common.misc.CoordinateHelper;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class WormholeModel {
    protected static final float DEFAULT_RADIUS = 3.5f;
    protected static final int DEFAULT_SIDES = 36;
    protected static final int MAX_LIGHT = 0xF000E0;
    protected static final float SHIELDING_OFFSET = 0.03125f;
    protected static final int DEFAULT_FRAMES = 32;
    protected static final float DEFAULT_SCALE = 0.03125f;
    protected float maxDefaultDistortion;
    protected float[][] outerCircle = WormholeModel.coordinates(36, 2.5f, 5.0f, 0);
    protected float[][] circle1 = WormholeModel.coordinates(36, 2.0f, 0.0f, 98);
    protected float[][] circle2 = WormholeModel.coordinates(36, 1.5f, -5.0f, 67);
    protected float[][] circle3 = WormholeModel.coordinates(36, 1.0f, -10.0f, 567);
    protected float[][] circle4 = WormholeModel.coordinates(36, 0.5f, -15.0f, 257);
    protected float[][] circle5 = WormholeModel.coordinates(36, 0.0f, 0.0f, -2);
    protected float[][][] coordinates = new float[][][]{this.outerCircle, this.circle1, this.circle2, this.circle3, this.circle4, this.circle5};
    protected static final short BLOCK_PROGRESS_1 = 7;
    protected static final short BLOCK_PROGRESS_2 = 24;
    protected static final short BLOCK_PROGRESS_3 = 36;
    protected static final short BLOCK_PROGRESS_4 = 44;
    protected static final short BLOCK_PROGRESS_5 = 53;

    public WormholeModel(float maxDefaultDistortion) {
        this.maxDefaultDistortion = maxDefaultDistortion;
    }

    protected float getMaxDistortion(int wormholeDistortion) {
        float distortion = (float)wormholeDistortion / 100.0f;
        return distortion > this.maxDefaultDistortion ? this.maxDefaultDistortion : distortion;
    }

    protected boolean isBlocked(int blockLayer, short blockProgress) {
        switch (blockLayer) {
            case -1: {
                return false;
            }
            case 0: {
                return blockProgress >= 7;
            }
            case 1: {
                return blockProgress >= 24;
            }
            case 2: {
                return blockProgress >= 36;
            }
            case 3: {
                return blockProgress >= 44;
            }
        }
        return blockProgress >= 53;
    }

    public void renderWormhole(AbstractStargateEntity stargate, PoseStack stack, MultiBufferSource source, ResourcepackModel.Wormhole wormhole, int combinedLight, int combinedOverlay) {
        short s;
        if (stargate instanceof IrisStargateEntity) {
            IrisStargateEntity irisStargate = (IrisStargateEntity)stargate;
            s = irisStargate.irisInfo().getIrisProgress();
        } else {
            s = 0;
        }
        short irisProgress = s;
        float wormholeDistortion = this.getMaxDistortion(wormhole.distortion());
        this.renderKawoosh(stack, source, wormhole, wormholeDistortion, stargate.getTickCount(), stargate.getKawooshTickCount(), irisProgress);
        this.renderEventHorizon(stack, source, wormhole, wormholeDistortion, stargate.getTickCount(), stargate.getKawooshTickCount(), irisProgress);
        if (wormhole.hasStrudel()) {
            this.renderStrudel(stack, source, wormhole, wormholeDistortion, stargate.getTickCount(), stargate.getKawooshTickCount(), irisProgress);
        }
    }

    protected void renderEventHorizon(PoseStack stack, MultiBufferSource source, ResourcepackModel.Wormhole wormhole, float wormholeDistortion, int ticks, int kawooshProgress, short irisProgress) {
        this.renderPuddle(stack, source, wormhole, wormholeDistortion, ticks, kawooshProgress, irisProgress);
    }

    protected void renderDisconnect(PoseStack stack, MultiBufferSource source, ResourcepackModel.Wormhole wormhole, float wormholeDistortion, int ticks, int kawooshProgress, short irisProgress) {
        this.renderPuddle(stack, source, wormhole, wormholeDistortion, ticks, kawooshProgress, irisProgress);
    }

    protected void renderPuddle(PoseStack stack, MultiBufferSource source, ResourcepackModel.Wormhole wormhole, float wormholeDistortion, int ticks, int kawooshProgress, short irisProgress) {
        if (kawooshProgress <= 0) {
            return;
        }
        float yOffset = (float)ticks * 0.03125f;
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        int totalSides = this.coordinates[0].length;
        ResourcepackModel.WormholeTexture frontTexture = wormhole.eventHorizonTexture(true);
        int frontFrame = frontTexture.frame(ticks);
        float uFrontScale = frontTexture.uScale();
        float vFrontScale = frontTexture.vScale();
        float uFrontOffset = frontTexture.uOffset(frontFrame);
        float vFrontOffset = frontTexture.vOffset(frontFrame);
        ColorUtil.RGBA frontRGBA = frontTexture.rgba();
        VertexConsumer frontConsumer = source.m_6299_(SGJourneyRenderTypes.eventHorizon(frontTexture.texture()));
        for (int i = 0; i < 5; ++i) {
            boolean isBlocked = this.isBlocked(i, irisProgress);
            boolean isBlockedOld = this.isBlocked(i - 1, irisProgress);
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(frontConsumer, matrix4, matrix3, this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, 0), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, 0), frontRGBA, uFrontScale, vFrontScale, uFrontOffset, vFrontOffset);
                this.createTriangle(frontConsumer, matrix4, matrix3, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, 0), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), frontRGBA, uFrontScale, vFrontScale, uFrontOffset, vFrontOffset);
            }
        }
        ResourcepackModel.WormholeTexture backTexture = wormhole.eventHorizonTexture(false);
        int backFrame = backTexture.frame(ticks);
        float uBackScale = backTexture.uScale();
        float vBackScale = backTexture.vScale();
        float uBackOffset = backTexture.uOffset(backFrame);
        float vBackOffset = backTexture.vOffset(backFrame);
        ColorUtil.RGBA backRGBA = backTexture.rgba();
        VertexConsumer backConsumer = source.m_6299_(SGJourneyRenderTypes.eventHorizon(backTexture.texture()));
        for (int i = 0; i < 5; ++i) {
            boolean isBlocked = this.isBlocked(i, irisProgress);
            boolean isBlockedOld = this.isBlocked(i - 1, irisProgress);
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(backConsumer, matrix4, matrix3, this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, 0), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, 0), backRGBA, uBackScale, vBackScale, uBackOffset, vBackOffset);
                this.createTriangle(backConsumer, matrix4, matrix3, this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, 0), this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, 0), backRGBA, uBackScale, vBackScale, uBackOffset, vBackOffset);
            }
        }
    }

    protected void renderKawoosh(PoseStack stack, MultiBufferSource source, ResourcepackModel.Wormhole wormhole, float wormholeDistortion, int ticks, int kawooshProgress, short irisProgress) {
        if (kawooshProgress <= 0 || kawooshProgress >= 40) {
            return;
        }
        float yOffset = (float)ticks * 0.03125f;
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        int totalSides = this.coordinates[0].length;
        ResourcepackModel.WormholeTexture frontTexture = wormhole.kawooshTexture(true);
        int frontFrame = frontTexture.frame(ticks);
        float uFrontScale = frontTexture.uScale();
        float vFrontScale = frontTexture.vScale();
        float uFrontOffset = frontTexture.uOffset(frontFrame);
        float vFrontOffset = frontTexture.vOffset(frontFrame);
        ColorUtil.RGBA frontRGBA = frontTexture.rgba();
        VertexConsumer frontConsumer = source.m_6299_(SGJourneyRenderTypes.vortex(frontTexture.texture()));
        for (int i = 0; i < 5; ++i) {
            boolean isBlocked = this.isBlocked(i, irisProgress);
            boolean isBlockedOld = this.isBlocked(i - 1, irisProgress);
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(frontConsumer, matrix4, matrix3, WormholeModel.bubbleX(this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), frontRGBA, uFrontScale, vFrontScale, uFrontOffset, vFrontOffset);
                this.createTriangle(frontConsumer, matrix4, matrix3, WormholeModel.bubbleX(this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), frontRGBA, uFrontScale, vFrontScale, uFrontOffset, vFrontOffset);
            }
        }
        ResourcepackModel.WormholeTexture backTexture = wormhole.kawooshTexture(false);
        int backFrame = backTexture.frame(ticks);
        float uBackScale = backTexture.uScale();
        float vBackScale = backTexture.vScale();
        float uBackOffset = backTexture.uOffset(backFrame);
        float vBackOffset = backTexture.vOffset(backFrame);
        ColorUtil.RGBA backRGBA = backTexture.rgba();
        VertexConsumer backConsumer = source.m_6299_(SGJourneyRenderTypes.vortex(backTexture.texture()));
        for (int i = 0; i < 5; ++i) {
            boolean isBlocked = this.isBlocked(i, irisProgress);
            boolean isBlockedOld = this.isBlocked(i - 1, irisProgress);
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(backConsumer, matrix4, matrix3, WormholeModel.bubbleX(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, kawooshProgress), backRGBA, uBackScale, vBackScale, uBackOffset, vBackOffset);
                this.createTriangle(backConsumer, matrix4, matrix3, WormholeModel.bubbleX(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], i, kawooshProgress), WormholeModel.distortionMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), WormholeModel.bubbleX(this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.bubbleY(this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], i + 1, kawooshProgress), WormholeModel.distortionMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), backRGBA, uBackScale, vBackScale, uBackOffset, vBackOffset);
            }
        }
    }

    protected void renderStrudel(PoseStack stack, MultiBufferSource source, ResourcepackModel.Wormhole wormhole, float wormholeDistortion, int ticks, int kawooshProgress, short irisProgress) {
        if (kawooshProgress <= 40) {
            return;
        }
        float yOffset = (float)ticks * 0.03125f;
        Matrix4f matrix4 = stack.m_85850_().m_252922_();
        Matrix3f matrix3 = stack.m_85850_().m_252943_();
        int totalSides = this.coordinates[0].length;
        ResourcepackModel.WormholeTexture frontTexture = wormhole.kawooshTexture(true);
        int frontFrame = frontTexture.frame(ticks);
        float uFrontScale = frontTexture.uScale();
        float vFrontScale = frontTexture.vScale();
        float uFrontOffset = frontTexture.uOffset(frontFrame);
        float vFrontOffset = frontTexture.vOffset(frontFrame);
        ColorUtil.RGBA frontRGBA = frontTexture.rgba();
        VertexConsumer frontConsumer = source.m_6299_(SGJourneyRenderTypes.vortex(frontTexture.texture()));
        for (int i = 0; i < 5; ++i) {
            boolean isBlocked = this.isBlocked(i, irisProgress);
            boolean isBlockedOld = this.isBlocked(i - 1, irisProgress);
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(frontConsumer, matrix4, matrix3, this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], WormholeModel.vortexMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, kawooshProgress), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.vortexMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), frontRGBA, uFrontScale, vFrontScale, uFrontOffset, vFrontOffset);
                this.createTriangle(frontConsumer, matrix4, matrix3, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.vortexMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), frontRGBA, uFrontScale, vFrontScale, uFrontOffset, vFrontOffset);
            }
        }
        ResourcepackModel.WormholeTexture backTexture = wormhole.strudelTexture(false);
        int backFrame = backTexture.frame(ticks);
        float uBackScale = backTexture.uScale();
        float vBackScale = backTexture.vScale();
        float uBackOffset = backTexture.uOffset(backFrame);
        float vBackOffset = backTexture.vOffset(backFrame);
        ColorUtil.RGBA backRGBA = backTexture.rgba();
        VertexConsumer backConsumer = source.m_6299_(SGJourneyRenderTypes.vortex(backTexture.texture()));
        for (int i = 0; i < 5; ++i) {
            boolean isBlocked = this.isBlocked(i, irisProgress);
            boolean isBlockedOld = this.isBlocked(i - 1, irisProgress);
            for (int j = 0; j < totalSides; ++j) {
                this.createTriangle(backConsumer, matrix4, matrix3, this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.vortexMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), this.coordinates[i][j % this.coordinates[i].length][0], this.coordinates[i][j % this.coordinates[i].length][1], WormholeModel.vortexMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][j % this.coordinates[i].length][2], yOffset, i, kawooshProgress), backRGBA, uBackScale, vBackScale, uBackOffset, vBackOffset);
                this.createTriangle(backConsumer, matrix4, matrix3, this.coordinates[i + 1][j % this.coordinates[i + 1].length][0], this.coordinates[i + 1][j % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][j % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), this.coordinates[i][(j + 1) % this.coordinates[i].length][0], this.coordinates[i][(j + 1) % this.coordinates[i].length][1], WormholeModel.vortexMaker(isBlockedOld, wormholeDistortion, this.coordinates[i][(j + 1) % this.coordinates[i].length][2], yOffset, i, kawooshProgress), this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][0], this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][1], WormholeModel.vortexMaker(isBlocked, wormholeDistortion, this.coordinates[i + 1][(j + 1) % this.coordinates[i + 1].length][2], yOffset, i + 1, kawooshProgress), backRGBA, uBackScale, vBackScale, uBackOffset, vBackOffset);
            }
        }
    }

    protected static float[][] coordinates(int sides, float distanceFromCenter, float offset, int seed) {
        float defaultOffset;
        Random random = new Random(seed);
        float angle = 360.0f / (float)sides;
        float[][] coordinates = new float[sides][3];
        float baseWidth = 0.6125f;
        float ratio = distanceFromCenter / 3.5f;
        float usedWidth = baseWidth * ratio;
        float circumcircleRadius = SGJourneyModel.circumcircleRadius(angle, usedWidth);
        float f = defaultOffset = seed == 0 ? 0.0f : random.nextFloat() - 0.5f;
        if (distanceFromCenter >= 0.0f) {
            for (int i = 0; i < sides; ++i) {
                coordinates[i][0] = CoordinateHelper.CoordinateSystems.polarToCartesianY(circumcircleRadius, angle * (float)i - offset);
                coordinates[i][1] = CoordinateHelper.CoordinateSystems.polarToCartesianX(circumcircleRadius, angle * (float)i - offset);
                coordinates[i][2] = seed <= 0 ? defaultOffset : 2.0f * random.nextFloat() - 1.0f;
            }
        } else {
            coordinates[0][0] = 0.0f;
            coordinates[0][1] = 0.0f;
            coordinates[0][2] = defaultOffset;
        }
        return coordinates;
    }

    protected static float bubbleX(float x, float y, int multiplier, int progress) {
        float r = CoordinateHelper.CoordinateSystems.cartesianToPolarR(x, y);
        float phi = CoordinateHelper.CoordinateSystems.cartesianToPolarPhi(x, y);
        r = (float)((double)r * (1.0 + 0.4 * (double)((float)(Math.pow(Math.sin((double)multiplier / 3.0), 4.0) * AbstractStargateEntity.kawooshFunction(progress)))));
        return CoordinateHelper.CoordinateSystems.polarToCartesianX(r, phi);
    }

    protected static float bubbleY(float x, float y, int multiplier, int progress) {
        float r = CoordinateHelper.CoordinateSystems.cartesianToPolarR(x, y);
        float phi = CoordinateHelper.CoordinateSystems.cartesianToPolarPhi(x, y);
        r = (float)((double)r * (1.0 + 0.4 * (double)((float)(Math.pow(Math.sin((double)multiplier / 3.0), 4.0) * AbstractStargateEntity.kawooshFunction(progress)))));
        return CoordinateHelper.CoordinateSystems.polarToCartesianY(r, phi);
    }

    protected static float distortionMaker(boolean shielded, float maxDefaultDistortion, float defaultOffset, float distortionOffset, int multiplier, int progress) {
        float defaultDistortion = (float)Math.sin((defaultOffset *= maxDefaultDistortion) * distortionOffset * 8.0f) * maxDefaultDistortion;
        float gradualKawoosh = (float)Math.pow(Math.sin((double)multiplier / 4.0), 2.0);
        float kawooshDistortion = (float)(1.2 * AbstractStargateEntity.kawooshFunction(progress)) * gradualKawoosh;
        float totalDistortion = defaultDistortion + kawooshDistortion;
        if (shielded && totalDistortion > -0.01875f) {
            totalDistortion = -0.01875f;
        }
        return totalDistortion < -maxDefaultDistortion ? -maxDefaultDistortion : totalDistortion;
    }

    protected static float vortexMaker(boolean shielded, float maxDefaultDistortion, float defaultOffset, float distortionOffset, int multiplier, int progress) {
        float defaultDistortion = (float)Math.sin((defaultOffset *= maxDefaultDistortion) * distortionOffset * 8.0f) * maxDefaultDistortion;
        float actualDistortion = defaultDistortion * (1.0f + (float)(Math.pow(Math.sin((double)multiplier / 5.0), 4.0) * AbstractStargateEntity.kawooshFunction(progress)));
        float gradualKawoosh = (float)Math.pow(Math.sin((double)multiplier / 5.0), 2.0);
        float kawooshDistortion = (float)(1.2 * AbstractStargateEntity.kawooshFunction(progress)) * gradualKawoosh;
        float totalDistortion = actualDistortion + kawooshDistortion;
        if (shielded && totalDistortion > -0.01875f) {
            totalDistortion = -0.01875f;
        }
        return totalDistortion;
    }

    protected void createTriangle(VertexConsumer consumer, Matrix4f matrix4, Matrix3f matrix3, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, ColorUtil.RGBA rgba, float uScale, float vScale, float uOffset, float vOffset) {
        float uHalfOffset = 0.5f * uScale;
        float vHalfOffset = 0.5f * vScale;
        if (StargateJourney.shouldRenderAMD()) {
            consumer.m_252986_(matrix4, x1, y1, z1).m_85950_(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).m_7421_(x1 * uScale / 5.0f + uHalfOffset + uOffset, y1 * vScale / 5.0f + vHalfOffset + vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000E0).m_252939_(matrix3, 0.0f, 0.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4, x2, y2, z2).m_85950_(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).m_7421_(x2 * uScale / 5.0f + uHalfOffset + uOffset, y2 * vScale / 5.0f + vHalfOffset + vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000E0).m_252939_(matrix3, 0.0f, 0.0f, 0.0f).m_5752_();
            consumer.m_252986_(matrix4, x3, y3, z3).m_85950_(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).m_7421_(x3 * uScale / 5.0f + uHalfOffset + uOffset, y3 * vScale / 5.0f + vHalfOffset + vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000E0).m_252939_(matrix3, 0.0f, 0.0f, 0.0f).m_5752_();
        } else {
            consumer.m_252986_(matrix4, x1, y1, z1).m_85950_(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).m_7421_(x1 * uScale / 5.0f + uHalfOffset + uOffset, y1 * vScale / 5.0f + vHalfOffset + vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000E0).m_252939_(matrix3, 1.0f, 1.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4, x2, y2, z2).m_85950_(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).m_7421_(x2 * uScale / 5.0f + uHalfOffset + uOffset, y2 * vScale / 5.0f + vHalfOffset + vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000E0).m_252939_(matrix3, 1.0f, 1.0f, 1.0f).m_5752_();
            consumer.m_252986_(matrix4, x3, y3, z3).m_85950_(rgba.red(), rgba.green(), rgba.blue(), rgba.alpha()).m_7421_(x3 * uScale / 5.0f + uHalfOffset + uOffset, y3 * vScale / 5.0f + vHalfOffset + vOffset).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000E0).m_252939_(matrix3, 1.0f, 1.0f, 1.0f).m_5752_();
        }
    }
}

