/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.blocks.dhd;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import net.povstalec.sgjourney.common.block_entities.StructureGenEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.AbstractDHDEntity;
import net.povstalec.sgjourney.common.block_entities.dhd.ClassicDHDEntity;
import net.povstalec.sgjourney.common.blocks.dhd.CrystalDHDBlock;
import net.povstalec.sgjourney.common.config.CommonCrystalConfig;
import net.povstalec.sgjourney.common.init.BlockEntityInit;
import net.povstalec.sgjourney.common.init.BlockInit;
import net.povstalec.sgjourney.common.init.ItemInit;
import net.povstalec.sgjourney.common.items.crystals.CommunicationCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.EnergyCrystalItem;
import net.povstalec.sgjourney.common.items.crystals.TransferCrystalItem;
import net.povstalec.sgjourney.common.menu.ClassicDHDMenu;
import net.povstalec.sgjourney.common.misc.InventoryUtil;

public class ClassicDHDBlock
extends CrystalDHDBlock {
    public ClassicDHDBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ClassicDHDEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace) {
        if (!level.m_5776_()) {
            final BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ClassicDHDEntity) {
                ClassicDHDEntity dhd = (ClassicDHDEntity)blockEntity;
                dhd.setStargate();
                if (player.m_6144_()) {
                    this.openCrystalMenu(player, dhd);
                } else {
                    MenuProvider containerProvider = new MenuProvider(){

                        public Component m_5446_() {
                            return Component.m_237115_((String)"screen.sgjourney.dhd");
                        }

                        public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                            return new ClassicDHDMenu(windowId, playerInventory, blockEntity);
                        }
                    };
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)containerProvider, (BlockPos)blockEntity.m_58899_());
                }
            } else {
                throw new IllegalStateException("Our named container provider is missing!");
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Block getDHD() {
        return (Block)BlockInit.CLASSIC_DHD.get();
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ClassicDHDBlock.createTickerHelper(type, (BlockEntityType)BlockEntityInit.CLASSIC_DHD.get(), AbstractDHDEntity::tick);
    }

    public static ItemStack generatedDHD() {
        ItemStack stack = new ItemStack((ItemLike)BlockInit.CLASSIC_DHD.get());
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.m_128359_("id", "sgjourney:classic_dhd");
        blockEntityTag.m_128344_("generation_step", StructureGenEntity.Step.SETUP.byteValue());
        stack.m_41700_("BlockEntityTag", (Tag)blockEntityTag);
        return stack;
    }

    public static ItemStack classicCrystalSetup() {
        ItemStack stack = new ItemStack((ItemLike)BlockInit.CLASSIC_DHD.get());
        CompoundTag blockEntityTag = new CompoundTag();
        blockEntityTag.m_128359_("id", "sgjourney:classic_dhd");
        blockEntityTag.m_128356_("Energy", 0L);
        CompoundTag crystalInventory = new CompoundTag();
        crystalInventory.m_128405_("Size", 9);
        crystalInventory.m_128365_("Items", (Tag)ClassicDHDBlock.setupCrystalInventory());
        blockEntityTag.m_128365_("Inventory", (Tag)crystalInventory);
        CompoundTag energyInventory = new CompoundTag();
        energyInventory.m_128405_("Size", 2);
        energyInventory.m_128365_("Items", (Tag)ClassicDHDBlock.setupEnergyInventory());
        blockEntityTag.m_128365_("energy_inventory", (Tag)energyInventory);
        stack.m_41700_("BlockEntityTag", (Tag)blockEntityTag);
        return stack;
    }

    private static ListTag setupEnergyInventory() {
        ListTag nbtTagList = new ListTag();
        nbtTagList.add((Object)InventoryUtil.addItem(0, InventoryUtil.itemName((Item)ItemInit.NAQUADAH_GENERATOR_CORE.get()), 1, null));
        nbtTagList.add((Object)InventoryUtil.addItem(1, InventoryUtil.itemName((Item)ItemInit.NAQUADAH_FUEL_ROD.get()), 1, null));
        return nbtTagList;
    }

    private static ListTag setupCrystalInventory() {
        ListTag nbtTagList = new ListTag();
        nbtTagList.add((Object)InventoryUtil.addItem(0, InventoryUtil.itemName((Item)ItemInit.LARGE_CONTROL_CRYSTAL.get()), 1, null));
        nbtTagList.add((Object)InventoryUtil.addItem(1, InventoryUtil.itemName((Item)ItemInit.ENERGY_CRYSTAL.get()), 1, EnergyCrystalItem.tagSetup(0)));
        nbtTagList.add((Object)InventoryUtil.addItem(2, InventoryUtil.itemName((Item)ItemInit.COMMUNICATION_CRYSTAL.get()), 1, CommunicationCrystalItem.tagSetup(0)));
        nbtTagList.add((Object)InventoryUtil.addItem(3, InventoryUtil.itemName((Item)ItemInit.ENERGY_CRYSTAL.get()), 1, EnergyCrystalItem.tagSetup(0)));
        nbtTagList.add((Object)InventoryUtil.addItem(5, InventoryUtil.itemName((Item)ItemInit.ENERGY_CRYSTAL.get()), 1, EnergyCrystalItem.tagSetup(0)));
        nbtTagList.add((Object)InventoryUtil.addItem(7, InventoryUtil.itemName((Item)ItemInit.TRANSFER_CRYSTAL.get()), 1, TransferCrystalItem.tagSetup((Long)CommonCrystalConfig.transfer_crystal_max_transfer.get())));
        return nbtTagList;
    }
}

