/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.povstalec.sgjourney.StargateJourney;
import net.povstalec.sgjourney.common.block_entities.transporter.AbstractTransporterEntity;
import net.povstalec.sgjourney.common.data.BlockEntityList;
import net.povstalec.sgjourney.common.misc.Conversion;
import net.povstalec.sgjourney.common.sgjourney.TransporterConnection;
import net.povstalec.sgjourney.common.sgjourney.transporter.Transporter;

public final class TransporterNetwork
extends SavedData {
    private static final String FILE_NAME = "sgjourney-transporter_network";
    private static final String DIMENSIONS = "dimensions";
    private static final String CONNECTIONS = "connections";
    private static final String VERSION = "version";
    private static final int UPDATE_VERSION = 2;
    private MinecraftServer server;
    private Map<String, Dimension> dimensions = new HashMap<String, Dimension>();
    private HashMap<UUID, TransporterConnection> connections = new HashMap();
    private int version = 0;

    public int getVersion() {
        return this.version;
    }

    private void updateVersion() {
        this.version = 2;
    }

    public void updateNetwork(MinecraftServer server) {
        if (this.getVersion() == 2) {
            StargateJourney.LOGGER.info("Transporter Network is up to date (Version: " + this.version + ")");
            return;
        }
        StargateJourney.LOGGER.info("Detected an incompatible Transporter Network version (Version: " + this.getVersion() + ") - updating to version 2");
        this.reloadNetwork(server, false);
    }

    public void reloadNetwork(MinecraftServer server, boolean updateInterfaces) {
        this.eraseNetwork();
        StargateJourney.LOGGER.info("Transporter Network erased");
        this.addTransporters();
        StargateJourney.LOGGER.info("Transporters added");
        this.updateVersion();
        StargateJourney.LOGGER.info("Version updated");
        this.m_77762_();
    }

    public void eraseNetwork() {
        this.dimensions.clear();
        this.m_77762_();
    }

    private void addTransporters() {
        HashMap<UUID, Transporter> transporters = BlockEntityList.get(this.server).getTransporters();
        transporters.entrySet().stream().forEach(transporterInfo -> {
            Transporter transporter = (Transporter)transporterInfo.getValue();
            BlockEntity blockentity = this.server.m_129880_(transporter.getDimension()).m_7702_(transporter.getBlockPos());
            if (blockentity instanceof AbstractTransporterEntity) {
                AbstractTransporterEntity transporterEntity = (AbstractTransporterEntity)blockentity;
                if (transporterEntity.getID() != null && transporterEntity.getID().equals(transporter.getID())) {
                    this.addTransporterToDimension(transporter.getDimension(), transporter);
                } else {
                    BlockEntityList.get(this.server).removeTransporter(transporter.getID());
                    this.addTransporter(transporterEntity);
                }
            } else {
                BlockEntityList.get(this.server).removeTransporter(transporter.getID());
            }
        });
    }

    public void addTransporter(Transporter transporter) {
        if (transporter != null) {
            this.addTransporterToDimension(transporter.getDimension(), transporter);
        }
        this.m_77762_();
    }

    public void addTransporter(AbstractTransporterEntity transporterEntity) {
        Transporter transporter = BlockEntityList.get(this.server).addTransporter(transporterEntity);
        if (transporter != null && transporterEntity.getID() != null && transporterEntity.getID().equals(transporter.getID())) {
            this.addTransporter(transporter);
        }
    }

    public void removeTransporter(Level level, UUID uuid) {
        if (uuid == null) {
            return;
        }
        Transporter transporter = this.getTransporter(uuid);
        if (transporter != null) {
            this.removeTransporterFromDimension((ResourceKey<Level>)level.m_46472_(), transporter);
        }
        BlockEntityList.get(level).removeTransporter(uuid);
        StargateJourney.LOGGER.info("Removed " + uuid.toString() + " from Transporter Network");
        this.m_77762_();
    }

    @Nullable
    public Transporter getTransporter(UUID uuid) {
        return BlockEntityList.get(this.server).getTransporter(uuid);
    }

    public void addTransporterToDimension(ResourceKey<Level> dimensionKey, Transporter transporter) {
        String dimensionString = dimensionKey.m_135782_().toString();
        if (!this.dimensions.containsKey(dimensionString)) {
            this.dimensions.put(dimensionString, new Dimension(dimensionKey));
        }
        this.dimensions.get(dimensionString).addTransporter(transporter);
    }

    public void removeTransporterFromDimension(ResourceKey<Level> dimensionKey, Transporter transporter) {
        String dimensionString = dimensionKey.m_135782_().toString();
        if (this.dimensions.containsKey(dimensionString)) {
            this.dimensions.get(dimensionString).removeTransporter(transporter);
        }
    }

    public Optional<List<Transporter>> getTransportersFromDimension(ResourceKey<Level> dimensionKey) {
        if (this.dimensions.containsKey(dimensionKey.m_135782_().toString())) {
            Dimension dimension = this.dimensions.get(dimensionKey.m_135782_().toString());
            return Optional.of(dimension.getTransporters());
        }
        return Optional.empty();
    }

    public final void printDimensions() {
        System.out.println("[Dimensions - Transporters]");
        this.dimensions.entrySet().stream().forEach(dimensionEntry -> ((Dimension)dimensionEntry.getValue()).printDimension());
    }

    public void handleConnections() {
        HashMap<UUID, TransporterConnection> connections = new HashMap<UUID, TransporterConnection>();
        connections.putAll(this.connections);
        connections.forEach((uuid, connection) -> connection.tick(this.server));
        this.m_77762_();
    }

    public boolean createConnection(MinecraftServer server, Transporter transporterA, Transporter transporterB) {
        TransporterConnection connection = TransporterConnection.create(server, transporterA, transporterB);
        if (connection == null) {
            return false;
        }
        return this.addConnection(connection);
    }

    public boolean addConnection(TransporterConnection connection) {
        if (this.hasConnection(connection.getID())) {
            return false;
        }
        this.connections.put(connection.getID(), connection);
        return true;
    }

    public boolean hasConnection(UUID uuid) {
        return this.connections.containsKey(uuid);
    }

    public void terminateConnection(UUID uuid) {
        TransporterConnection connection = this.connections.get(uuid);
        if (connection == null) {
            return;
        }
        connection.terminate(this.server);
    }

    public void removeConnection(UUID uuid) {
        if (this.hasConnection(uuid)) {
            this.connections.remove(uuid);
            StargateJourney.LOGGER.debug("Removed connection " + uuid);
        } else {
            StargateJourney.LOGGER.error("Could not find connection " + uuid);
        }
        this.m_77762_();
    }

    private CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_(VERSION, this.version);
        tag.m_128365_(DIMENSIONS, (Tag)this.serializeDimensions());
        tag.m_128365_(CONNECTIONS, (Tag)this.serializeConnections());
        return tag;
    }

    private CompoundTag serializeDimensions() {
        CompoundTag dimensionsTag = new CompoundTag();
        this.dimensions.forEach((dimensionString, dimension) -> dimensionsTag.m_128365_(dimensionString, (Tag)dimension.serialize()));
        return dimensionsTag;
    }

    private CompoundTag serializeConnections() {
        CompoundTag connectionsTag = new CompoundTag();
        this.connections.forEach((connectionID, connection) -> connectionsTag.m_128365_(connectionID.toString(), (Tag)connection.serialize()));
        return connectionsTag;
    }

    private void deserialize(CompoundTag tag) {
        this.version = tag.m_128451_(VERSION);
        this.deserializeDimensions(tag.m_128469_(DIMENSIONS));
        this.deserializeConnections(tag.m_128469_(CONNECTIONS));
    }

    private void deserializeDimensions(CompoundTag tag) {
        tag.m_128431_().forEach(dimensionString -> this.dimensions.put((String)dimensionString, Dimension.deserialize(this.server, tag.m_128469_(dimensionString))));
    }

    private void deserializeConnections(CompoundTag tag) {
        for (String connectionID : tag.m_128431_()) {
            try {
                UUID uuid = UUID.fromString(connectionID);
                TransporterConnection connection = TransporterConnection.deserialize(this.server, UUID.fromString(connectionID), tag.m_128469_(connectionID));
                if (connection == null) continue;
                this.connections.put(uuid, connection);
            }
            catch (IllegalArgumentException e) {
                StargateJourney.LOGGER.error(e.toString());
            }
        }
    }

    public TransporterNetwork(MinecraftServer server) {
        this.server = server;
    }

    public static TransporterNetwork create(MinecraftServer server) {
        return new TransporterNetwork(server);
    }

    public static TransporterNetwork load(MinecraftServer server, CompoundTag tag) {
        TransporterNetwork data = TransporterNetwork.create(server);
        data.server = server;
        data.deserialize(tag);
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        tag = this.serialize();
        return tag;
    }

    @Nonnull
    public static TransporterNetwork get(Level level) {
        if (level.m_5776_()) {
            throw new RuntimeException("Don't access this client-side!");
        }
        return TransporterNetwork.get(level.m_7654_());
    }

    @Nonnull
    public static TransporterNetwork get(MinecraftServer server) {
        DimensionDataStorage storage = server.m_129783_().m_8895_();
        return (TransporterNetwork)storage.m_164861_(tag -> TransporterNetwork.load(server, tag), () -> TransporterNetwork.create(server), FILE_NAME);
    }

    private static class Dimension {
        private static final String DIMENSION = "Dimension";
        private static final String TRANSPORTERS = "Transporters";
        private final ResourceKey<Level> dimension;
        private List<Transporter> transporters = new ArrayList<Transporter>();

        private Dimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
        }

        private Dimension(ResourceKey<Level> dimension, List<Transporter> transporters) {
            this.dimension = dimension;
            this.transporters = transporters;
        }

        public void addTransporter(Transporter transporter) {
            if (this.transporters.contains(transporter)) {
                return;
            }
            this.transporters.add(transporter);
        }

        public void removeTransporter(Transporter transporter) {
            if (this.transporters.contains(transporter)) {
                this.transporters.remove(transporter);
            }
        }

        public List<Transporter> getTransporters() {
            return new ArrayList<Transporter>(this.transporters);
        }

        public void printDimension() {
            System.out.println("- [" + this.dimension.m_135782_().toString() + "]");
            this.transporters.stream().forEach(transporter -> System.out.println("--- " + transporter.toString()));
        }

        public CompoundTag serialize() {
            CompoundTag dimensionTag = new CompoundTag();
            dimensionTag.m_128359_(DIMENSION, this.dimension.m_135782_().toString());
            CompoundTag transportersTag = new CompoundTag();
            this.transporters.stream().forEach(transporter -> transportersTag.m_128359_(transporter.getID().toString(), transporter.getID().toString()));
            dimensionTag.m_128365_(TRANSPORTERS, (Tag)transportersTag);
            return dimensionTag;
        }

        public static Dimension deserialize(MinecraftServer server, CompoundTag dimensionTag) {
            ResourceKey<Level> dimension = Conversion.stringToDimension(dimensionTag.m_128461_(DIMENSION));
            ArrayList<Transporter> transporters = new ArrayList<Transporter>();
            dimensionTag.m_128469_(TRANSPORTERS).m_128431_().forEach(transporterID -> {
                Transporter transporter = BlockEntityList.get(server).getTransporter(UUID.fromString(transporterID));
                if (transporter != null) {
                    transporters.add(transporter);
                }
            });
            return new Dimension(dimension, transporters);
        }
    }
}

