/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.items;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import net.minecraftforge.items.IItemHandler;
import net.povstalec.sgjourney.common.capabilities.ItemFluidHolderProvider;
import net.povstalec.sgjourney.common.init.FluidInit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FluidItem
extends Item {
    public FluidItem(Item.Properties properties) {
        super(properties);
    }

    public float getFluidPercentage(ItemStack stack) {
        if (this.getFluidCapacity(stack) <= 0) {
            return 0.0f;
        }
        return (float)this.getFluidAmount(stack) / (float)this.getFluidCapacity(stack);
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * this.getFluidPercentage(stack));
    }

    public int m_142159_(ItemStack stack) {
        float f = Math.max(0.0f, this.getFluidPercentage(stack));
        return Mth.m_14169_((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public abstract boolean isCorrectFluid(FluidStack var1);

    public abstract int getFluidCapacity(ItemStack var1);

    public FluidStack getFluidStack(ItemStack stack) {
        IFluidHandler fluidHandler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().orElse(null);
        if (fluidHandler == null) {
            return FluidStack.EMPTY;
        }
        return fluidHandler.getFluidInTank(0);
    }

    public int getFluidAmount(ItemStack stack) {
        return this.getFluidStack(stack).getAmount();
    }

    public void drainFluid(ItemStack stack, int amount) {
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE));
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
        return new FluidHandlerItemStack(stack, this.getFluidCapacity(stack)){

            public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
                return FluidItem.this.isCorrectFluid(fluidStack);
            }
        };
    }

    protected ChatFormatting fluidComponentColor(FluidStack fluidStack) {
        if (fluidStack.getFluid() == FluidInit.LIQUID_NAQUADAH_SOURCE.get()) {
            return ChatFormatting.GREEN;
        }
        if (fluidStack.getFluid() == FluidInit.HEAVY_LIQUID_NAQUADAH_SOURCE.get()) {
            return ChatFormatting.DARK_GREEN;
        }
        return ChatFormatting.WHITE;
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        FluidStack fluidStack = this.getFluidStack(stack);
        MutableComponent fluidComponent = Component.m_237115_((String)"tooltip.sgjourney.fluid").m_7220_((Component)Component.m_237113_((String)": "));
        if (fluidStack.isEmpty()) {
            fluidComponent.m_130946_("0 mB");
        } else {
            fluidComponent.m_7220_((Component)Component.m_237115_((String)fluidStack.getTranslationKey()));
            fluidComponent.m_7220_((Component)Component.m_237113_((String)(" " + fluidStack.getAmount() + "mB")));
        }
        fluidComponent.m_130940_(this.fluidComponentColor(fluidStack));
        tooltipComponents.add((Component)fluidComponent);
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    public static ItemStack fluidSetup(Item item, Fluid fluid, int amount) {
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).ifPresent(fluidHandler -> fluidHandler.fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE));
        return stack;
    }

    public static abstract class Holder
    extends FluidItem {
        public Holder(Item.Properties properties) {
            super(properties);
        }

        public abstract ItemStack getHeldItem(ItemStack var1);

        public abstract boolean isValidItem(ItemStack var1);

        @Override
        public int getFluidCapacity(ItemStack stack) {
            Item item = this.getHeldItem(stack).m_41720_();
            if (item instanceof FluidItem) {
                FluidItem fluidItem = (FluidItem)item;
                return fluidItem.getFluidCapacity(stack);
            }
            return 0;
        }

        @Override
        public FluidStack getFluidStack(ItemStack stack) {
            Item item;
            ItemStack heldStack = this.getHeldItem(stack);
            if (!heldStack.m_41619_() && (item = heldStack.m_41720_()) instanceof FluidItem) {
                FluidItem fluidItem = (FluidItem)item;
                if (this.isValidItem(heldStack)) {
                    return fluidItem.getFluidStack(heldStack);
                }
            }
            return FluidStack.EMPTY;
        }

        @Override
        public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag tag) {
            return new ItemFluidHolderProvider(stack){

                @Override
                public boolean isValid(@NotNull ItemStack stack) {
                    return !(stack.m_41720_() instanceof Holder) && this.isValidItem(stack);
                }

                @NotNull
                public FluidStack getFluidInTank(int tank) {
                    if (!this.hasItem()) {
                        return FluidStack.EMPTY;
                    }
                    ItemStack heldStack = this.getHeldItem(this.stack);
                    Item item = heldStack.m_41720_();
                    if (item instanceof FluidItem) {
                        FluidItem fluidItem = (FluidItem)item;
                        return fluidItem.getFluidStack(heldStack);
                    }
                    return FluidStack.EMPTY;
                }

                public int getTankCapacity(int tank) {
                    if (!this.hasItem()) {
                        return 0;
                    }
                    ItemStack heldStack = this.getHeldItem(this.stack);
                    Item item = heldStack.m_41720_();
                    if (item instanceof FluidItem) {
                        FluidItem fluidItem = (FluidItem)item;
                        return fluidItem.getFluidCapacity(heldStack);
                    }
                    return 0;
                }

                public boolean isFluidValid(int tank, @NotNull FluidStack fluidStack) {
                    return this.isCorrectFluid(fluidStack);
                }
            };
        }

        public boolean swapItem(Player player, ItemStack holderStack, ItemStack insertedStack) {
            IItemHandler itemHandler = holderStack.getCapability(ForgeCapabilities.ITEM_HANDLER).resolve().orElse(null);
            if (itemHandler != null && (insertedStack.m_41619_() || this.isValidItem(insertedStack))) {
                ItemStack returnStack = itemHandler.extractItem(0, 1, false);
                itemHandler.insertItem(0, insertedStack, false);
                player.m_21008_(InteractionHand.MAIN_HAND, returnStack);
                return true;
            }
            return false;
        }

        @NotNull
        public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
            ItemStack offHandStack = player.m_21120_(InteractionHand.OFF_HAND);
            Item item = offHandStack.m_41720_();
            if (item instanceof Holder) {
                Holder holder = (Holder)item;
                if (!level.m_5776_() && holder.swapItem(player, offHandStack, player.m_21120_(InteractionHand.MAIN_HAND))) {
                    return InteractionResultHolder.m_19090_((Object)offHandStack);
                }
            }
            return super.m_7203_(level, player, hand);
        }

        @Override
        public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
            ItemStack heldItem = this.getHeldItem(stack);
            MutableComponent itemComponent = Component.m_237115_((String)"tooltip.sgjourney.holding").m_7220_((Component)Component.m_237113_((String)": "));
            if (heldItem.m_41619_()) {
                itemComponent.m_130946_("[-]");
            } else {
                itemComponent.m_7220_(heldItem.m_41611_());
            }
            tooltipComponents.add((Component)itemComponent);
            super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        }
    }
}

