/*
 * Decompiled with CFR 0.152.
 */
package net.povstalec.sgjourney.common.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.povstalec.sgjourney.common.config.CommonGenerationConfig;
import net.povstalec.sgjourney.common.init.StructureInit;
import net.povstalec.sgjourney.common.structures.StargateStructure;

public class BuriedStargate
extends StargateStructure {
    public static final Codec<BuriedStargate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuriedStargate.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.BOOL.optionalFieldOf("common_stargates").forGetter(structure -> Optional.ofNullable(structure.commonStargates)), (App)StargateStructure.StargateModifiers.CODEC.optionalFieldOf("stargate_modifiers").forGetter(structure -> Optional.ofNullable(structure.stargateModifiers)), (App)StargateStructure.DHDModifiers.CODEC.optionalFieldOf("dhd_modifiers").forGetter(structure -> Optional.ofNullable(structure.dhdModifiers))).apply((Applicative)instance, BuriedStargate::new)).codec();
    private static Optional<Long> currentSeed = Optional.empty();
    private static Optional<Integer> x = Optional.empty();
    private static Optional<Integer> z = Optional.empty();

    public BuriedStargate(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Optional<Boolean> commonStargates, Optional<StargateStructure.StargateModifiers> stargateModifiers, Optional<StargateStructure.DHDModifiers> dhdModifiers) {
        super(config, startPool, startJigsawName, size, startHeight, projectStartToHeightmap, maxDistanceFromCenter, commonStargates, stargateModifiers, dhdModifiers);
    }

    private static final void checkSeed(long seed) {
        if (currentSeed.isEmpty() || currentSeed.isPresent() && currentSeed.get() != seed) {
            currentSeed = Optional.of(seed);
            x = Optional.empty();
            z = Optional.empty();
        }
    }

    public static int getX(long seed) {
        BuriedStargate.checkSeed(seed);
        if (x.isEmpty()) {
            Random random = new Random(seed);
            int xOffset = (Integer)CommonGenerationConfig.stargate_generation_center_x_chunk_offset.get();
            int xBound = (Integer)CommonGenerationConfig.buried_stargate_generation_x_bound.get();
            int chunkX = xBound <= 0 ? xOffset : xOffset + random.nextInt(-xBound, xBound + 1);
            x = Optional.of(chunkX);
        }
        return x.get();
    }

    public static int getZ(long seed) {
        BuriedStargate.checkSeed(seed);
        if (z.isEmpty()) {
            Random random = new Random(seed + 1L);
            int zOffset = (Integer)CommonGenerationConfig.stargate_generation_center_z_chunk_offset.get();
            int zBound = (Integer)CommonGenerationConfig.buried_stargate_generation_z_bound.get();
            int chunkZ = zBound <= 0 ? zOffset : zOffset + random.nextInt(-zBound, zBound + 1);
            z = Optional.of(chunkZ);
        }
        return z.get();
    }

    @Override
    protected boolean extraSpawningChecks(Structure.GenerationContext context) {
        ChunkPos chunkpos = context.f_226628_();
        long seed = context.f_226627_();
        return chunkpos.f_45578_ == BuriedStargate.getX(seed) && chunkpos.f_45579_ == BuriedStargate.getZ(seed);
    }

    public Optional<Structure.GenerationStub> m_262864_(Structure.GenerationContext context) {
        return super.m_262864_(context);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)StructureInit.BURIED_STARGATE.get();
    }
}

