/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.LanternMaterial;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class LanternBlock
extends net.minecraft.world.level.block.LanternBlock {
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");
    public static final BooleanProperty REDSTONE = BooleanProperty.m_61465_((String)"redstone");
    public final LanternMaterial material;
    public final LanternColor color;

    public LanternBlock(LanternMaterial material, LanternColor color) {
        super(material.getLanternBlockProperties());
        this.material = material;
        this.color = color;
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ON, (Comparable)Boolean.valueOf(true))).m_61124_((Property)REDSTONE, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        ItemStack stack = player.m_21120_(hand);
        if (this.material.canBeColored && stack.m_41720_() instanceof DyeItem) {
            LanternColor color = LanternColor.fromDyeColor(((DyeItem)stack.m_41720_()).m_41089_());
            BlockState newState = this.material.getLanternBlock(color).m_49966_();
            newState = (BlockState)newState.m_61124_((Property)f_153460_, (Comparable)((Boolean)state.m_61143_((Property)f_153460_)));
            newState = (BlockState)newState.m_61124_((Property)f_153459_, (Comparable)((Boolean)state.m_61143_((Property)f_153459_)));
            newState = (BlockState)newState.m_61124_((Property)ON, (Comparable)((Boolean)state.m_61143_((Property)ON)));
            newState = (BlockState)newState.m_61124_((Property)REDSTONE, (Comparable)((Boolean)state.m_61143_((Property)REDSTONE)));
            world.m_7731_(pos, newState, 3);
        } else if (this.material == LanternMaterial.NORMAL && this.color == null && !((Boolean)state.m_61143_((Property)ON)).booleanValue() && !((Boolean)state.m_61143_((Property)REDSTONE)).booleanValue()) {
            world.m_7731_(pos, (BlockState)((BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)((Boolean)state.m_61143_((Property)f_153459_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)f_153460_))), 3);
        } else {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)ON, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)ON) == false)), 3);
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ON, REDSTONE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return state == null ? null : (BlockState)state.m_61124_((Property)REDSTONE, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())));
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos neighborPos, boolean p_220069_6_) {
        if (!world.f_46443_) {
            boolean redstone = world.m_276867_(pos);
            if (this.material == LanternMaterial.NORMAL && this.color == null && ((Boolean)state.m_61143_((Property)ON)).booleanValue() && !redstone) {
                world.m_7731_(pos, (BlockState)((BlockState)Blocks.f_50681_.m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)((Boolean)state.m_61143_((Property)f_153459_)))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)((Boolean)state.m_61143_((Property)f_153460_))), 7);
            } else if ((Boolean)state.m_61143_((Property)REDSTONE) != redstone) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)REDSTONE, (Comparable)Boolean.valueOf(redstone)), 7);
            }
        }
    }

    public static boolean emitsLight(BlockState state) {
        return state.m_61143_((Property)REDSTONE) != state.m_61143_((Property)ON);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (this.material == LanternMaterial.NORMAL && this.color == null) {
            return new ItemStack((ItemLike)Blocks.f_50681_);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }
}

