/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.additionallanterns;

import com.google.common.collect.ImmutableMap;
import com.supermartijn642.additionallanterns.AdditionalLanterns;
import com.supermartijn642.additionallanterns.ChainBlock;
import com.supermartijn642.additionallanterns.LanternBlock;
import com.supermartijn642.additionallanterns.LanternColor;
import com.supermartijn642.additionallanterns.WeatheringChainBlock;
import com.supermartijn642.additionallanterns.WeatheringLanternBlock;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;

public enum LanternMaterial {
    AMETHYST(true, true, "Amethyst", () -> Items.f_151049_, null, 1, () -> Items.f_150998_, () -> Items.f_151049_, 4),
    ANDESITE(true, true, "Andesite", () -> Items.f_42170_, null, 4, () -> Items.f_42170_, () -> Items.f_42170_, 8),
    BASALT(true, true, "Basalt", () -> Items.f_42051_, null, 4, () -> Items.f_42051_, () -> Items.f_42051_, 8),
    BLACKSTONE(true, true, "Blackstone", () -> Items.f_42755_, null, 4, () -> Items.f_42755_, () -> Items.f_42755_, 8),
    BONE(true, true, "Bone", () -> Items.f_42500_, () -> Items.f_42500_, 1, () -> Items.f_42262_, () -> Items.f_42500_, 3),
    BRICKS(true, true, "Brick", () -> Items.f_42460_, null, 1, () -> Items.f_41995_, () -> Items.f_42460_, 4),
    COBBLESTONE(true, true, "Cobblestone", () -> Items.f_42594_, null, 4, () -> Items.f_42594_, () -> Items.f_42594_, 8),
    COBBLED_DEEPSLATE(true, true, "Cobbled Deepslate", () -> Items.f_151035_, null, 4, () -> Items.f_151035_, () -> Items.f_151035_, 8),
    COPPER(true, true, "Copper", () -> Items.f_151052_, null, 1, () -> Items.f_151000_, () -> Items.f_151052_, 4),
    CRIMSON(true, true, "Crimson", () -> Items.f_42797_, null, 4, () -> Items.f_42797_, () -> Items.f_42797_, 8),
    DARK_PRISMARINE(true, true, "Dark Prismarine", () -> Items.f_42194_, null, 1, () -> Items.f_42194_, () -> Items.f_42695_, 4),
    DEEPSLATE_BRICKS(true, true, "Deepslate Bricks", () -> Items.f_151020_, null, 4, () -> Items.f_151020_, () -> Items.f_151020_, 8),
    DIAMOND(true, true, "Diamond", () -> Items.f_42415_, null, 1, () -> Items.f_42415_, () -> Items.f_42415_, 3),
    DIORITE(true, true, "Diorite", () -> Items.f_42064_, null, 4, () -> Items.f_42064_, () -> Items.f_42064_, 8),
    EMERALD(true, true, "Emerald", () -> Items.f_42616_, null, 1, () -> Items.f_42616_, () -> Items.f_42616_, 3),
    END_STONE(true, true, "End Stone", () -> Items.f_42102_, null, 4, () -> Items.f_42102_, () -> Items.f_42102_, 8),
    EXPOSED_COPPER(true, true, "Exposed Copper", null, null, 0, null, null, 0),
    GOLD(true, true, "Gold", () -> Items.f_42587_, (ItemLike)Items.f_42587_, 1, () -> Items.f_42417_, () -> Items.f_42587_, 1),
    GRANITE(true, true, "Granite", () -> Items.f_41958_, null, 4, () -> Items.f_41958_, () -> Items.f_41958_, 8),
    IRON(true, false, "Iron", () -> Items.f_42416_, null, 1, null, null, 0),
    MOSSY_COBBLESTONE(true, true, "Mossy Cobblestone", () -> Items.f_41998_, null, 4, () -> Items.f_41998_, () -> Items.f_42594_, 8),
    NETHERITE(true, true, "Netherite", () -> Items.f_42418_, null, 1, () -> Items.f_42418_, () -> Items.f_42418_, 3),
    NORMAL(true, false, "", null, null, 0, null, null, 0),
    NORMAL_NETHER_BRICKS(true, true, "Nether Brick", () -> Items.f_42691_, null, 1, () -> Items.f_42095_, () -> Items.f_42691_, 3),
    NORMAL_SANDSTONE(true, true, "Sandstone", () -> Items.f_41856_, null, 4, () -> Items.f_41856_, () -> Items.f_41856_, 8),
    OBSIDIAN(true, true, "Obsidian", () -> Items.f_41999_, null, 4, () -> Items.f_41999_, () -> Items.f_41999_, 8),
    OXIDIZED_COPPER(true, true, "Oxidized Copper", null, null, 0, null, null, 0),
    PRISMARINE(true, true, "Prismarine", () -> Items.f_42695_, null, 1, () -> Items.f_42193_, () -> Items.f_42695_, 4),
    PURPUR(true, true, "Purpur", () -> Items.f_42731_, null, 1, () -> Items.f_42004_, () -> Items.f_42731_, 4),
    QUARTZ(true, true, "Quartz", () -> Items.f_42692_, () -> Items.f_42692_, 1, () -> Items.f_42157_, () -> Items.f_42692_, 4),
    RED_NETHER_BRICKS(true, true, "Red Nether Brick", () -> Items.f_42261_, null, 4, () -> Items.f_42261_, () -> Items.f_42691_, 8),
    RED_SANDSTONE(true, true, "Red Sandstone", () -> Items.f_42252_, null, 4, () -> Items.f_42252_, () -> Items.f_42252_, 8),
    SMOOTH_STONE(true, true, "Smooth Stone", () -> Items.f_41994_, null, 4, () -> Items.f_41994_, () -> Items.f_41994_, 8),
    STONE(true, true, "Stone", () -> Items.f_41905_, null, 4, () -> Items.f_41905_, () -> Items.f_41905_, 8),
    STONE_BRICKS(true, true, "Stone Bricks", () -> Items.f_42018_, null, 4, () -> Items.f_42018_, () -> Items.f_42018_, 8),
    WARPED(true, true, "Warped", () -> Items.f_42798_, null, 4, () -> Items.f_42798_, () -> Items.f_42798_, 8),
    WAXED_COPPER(true, true, "Waxed Copper", null, null, 0, null, null, 0),
    WAXED_EXPOSED_COPPER(true, true, "Waxed Exposed Copper", null, null, 0, null, null, 0),
    WAXED_OXIDIZED_COPPER(true, true, "Waxed Oxidized Copper", null, null, 0, null, null, 0),
    WAXED_WEATHERED_COPPER(true, true, "Waxed Weathered Copper", null, null, 0, null, null, 0),
    WEATHERED_COPPER(true, true, "Weathered Copper", null, null, 0, null, null, 0);

    private static final Map<LanternMaterial, WeatheringCopper.WeatherState> WEATHERING_BLOCKS;
    public final boolean canBeColored;
    public final boolean hasChains;
    private LanternBlock lanternBlock;
    private final Map<LanternColor, LanternBlock> coloredLanternBlocks = new EnumMap<LanternColor, LanternBlock>(LanternColor.class);
    private ChainBlock chainBlock;
    private Item lanternItem;
    private final Map<LanternColor, Item> coloredLanternItems = new EnumMap<LanternColor, Item>(LanternColor.class);
    private Item chainItem;
    public final String englishTranslation;
    public final ItemLike primaryLanternIngredient;
    public final ItemLike secondaryLanternIngredient;
    public final int lanternRecipeCount;
    public final ItemLike primaryChainIngredient;
    public final ItemLike secondaryChainIngredient;
    public final int chainRecipeCount;

    private LanternMaterial(boolean canBeColored, boolean hasChains, String englishTranslation, ItemLike primaryLanternIngredient, ItemLike secondaryLanternIngredient, int lanternRecipeCount, ItemLike primaryChainIngredient, ItemLike secondaryChainIngredient, int chainRecipeCount) {
        this.canBeColored = canBeColored;
        this.hasChains = hasChains;
        this.englishTranslation = englishTranslation;
        this.primaryLanternIngredient = primaryLanternIngredient;
        this.secondaryLanternIngredient = secondaryLanternIngredient;
        this.lanternRecipeCount = lanternRecipeCount;
        this.primaryChainIngredient = primaryChainIngredient;
        this.secondaryChainIngredient = secondaryChainIngredient;
        this.chainRecipeCount = chainRecipeCount;
    }

    public Block getLanternBlock() {
        return this.lanternBlock;
    }

    public Block getLanternBlock(LanternColor color) {
        if (color == null) {
            return this.getLanternBlock();
        }
        return (Block)this.coloredLanternBlocks.get((Object)color);
    }

    public ChainBlock getChainBlock() {
        return this.chainBlock;
    }

    public String getSuffix() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    private String getLanternIdentifier(LanternColor color) {
        if (color == null) {
            return this.getSuffix() + "_lantern";
        }
        return color.getSuffix() + "_" + this.getSuffix() + "_lantern";
    }

    private String getChainIdentifier() {
        return this.getSuffix() + "_chain";
    }

    public BlockBehaviour.Properties getLanternBlockProperties() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50681_).m_60953_(state -> LanternBlock.emitsLight(state) ? 15 : 0);
        return WEATHERING_BLOCKS.get((Object)this) == null ? properties : properties.m_60977_();
    }

    public BlockBehaviour.Properties getChainBlockProperties() {
        return BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50184_);
    }

    public void registerBlocks(RegistrationHandler.Helper<Block> helper) {
        if (this.lanternBlock != null) {
            throw new IllegalStateException("Blocks have already been registered!");
        }
        WeatheringCopper.WeatherState weathering = WEATHERING_BLOCKS.get((Object)this);
        this.lanternBlock = weathering == null ? new LanternBlock(this, null) : new WeatheringLanternBlock(this, null, weathering);
        helper.register(this.getLanternIdentifier(null), (Object)this.lanternBlock);
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = weathering == null ? new LanternBlock(this, color) : new WeatheringLanternBlock(this, color, weathering);
                this.coloredLanternBlocks.put(color, block);
                helper.register(this.getLanternIdentifier(color), (Object)block);
            }
        }
        if (this.hasChains) {
            this.chainBlock = weathering == null ? new ChainBlock(this) : new WeatheringChainBlock(this, weathering);
            helper.register(this.getChainIdentifier(), (Object)this.chainBlock);
        }
    }

    public void registerItems(RegistrationHandler.Helper<Item> helper) {
        if (this.lanternItem != null) {
            throw new IllegalStateException("Items have already been registered!");
        }
        if (this.lanternBlock == null) {
            throw new IllegalStateException("Blocks must be registered before registering items!");
        }
        if (this != NORMAL) {
            this.lanternItem = new BaseBlockItem((Block)this.lanternBlock, ItemProperties.create().group((CreativeModeTab)AdditionalLanterns.GROUP));
            helper.register(this.getLanternIdentifier(null), (Object)this.lanternItem);
        }
        if (this.canBeColored) {
            for (LanternColor color : LanternColor.values()) {
                LanternBlock block = this.coloredLanternBlocks.get((Object)color);
                BaseBlockItem item = new BaseBlockItem((Block)block, ItemProperties.create().group((CreativeModeTab)AdditionalLanterns.GROUP));
                this.coloredLanternItems.put(color, (Item)item);
                helper.register(this.getLanternIdentifier(color), (Object)item);
            }
        }
        if (this.hasChains) {
            this.chainItem = new BaseBlockItem((Block)this.chainBlock, ItemProperties.create().group((CreativeModeTab)AdditionalLanterns.GROUP));
            helper.register(this.getChainIdentifier(), (Object)this.chainItem);
        }
    }

    static {
        WEATHERING_BLOCKS = ImmutableMap.builder().put((Object)COPPER, (Object)WeatheringCopper.WeatherState.UNAFFECTED).put((Object)EXPOSED_COPPER, (Object)WeatheringCopper.WeatherState.EXPOSED).put((Object)WEATHERED_COPPER, (Object)WeatheringCopper.WeatherState.WEATHERED).put((Object)OXIDIZED_COPPER, (Object)WeatheringCopper.WeatherState.OXIDIZED).build();
    }
}

