/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.setup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class Config {
    public static void init() {
        ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
        SERVER_BUILDER.comment("DimStorage's config");
        DimBlock.registerServerConfig(SERVER_BUILDER);
        DimTablet.registerServerConfig(SERVER_BUILDER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_BUILDER.build());
    }

    public static class DimBlock {
        public static ForgeConfigSpec.BooleanValue ALLOW_CONFIG;
        public static ForgeConfigSpec.BooleanValue ALLOW_PRIVATE_NETWORK;

        public static void registerServerConfig(ForgeConfigSpec.Builder SERVER_BUILDER) {
            SERVER_BUILDER.push("DimChest/DimTank");
            ALLOW_CONFIG = SERVER_BUILDER.comment("Allow players to change the DimChest/DimTank's frequency, default: true").define("allowFrequency", true);
            ALLOW_PRIVATE_NETWORK = SERVER_BUILDER.comment("Allow players to make DimChest/DimTank private, default: true").define("allowPrivateNetwork", true);
            SERVER_BUILDER.pop();
        }
    }

    public static class DimTablet {
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> ALLOW_LIST;

        public static void registerServerConfig(ForgeConfigSpec.Builder SERVER_BUILDER) {
            SERVER_BUILDER.push("DimTablet");
            ALLOW_LIST = SERVER_BUILDER.comment(new String[]{"A list of blocks that the DimTablet takes and transfers to the connected DimChest", "[/dimstorage add] adds the item you have in the main hand to this list"}).defineList("allow_list", DimTablet.allowList(), o -> ResourceLocation.m_135830_((String)o.toString()));
            SERVER_BUILDER.pop();
        }

        public static boolean containItem(Item item) {
            return ((List)ALLOW_LIST.get()).contains(DimTablet.getResourceLocation(item));
        }

        public static boolean addItem(Item item) {
            if (item.equals(Items.f_41852_)) {
                return false;
            }
            if (DimTablet.containItem(item)) {
                return false;
            }
            ArrayList<String> newList = new ArrayList<String>((Collection)ALLOW_LIST.get());
            newList.add(DimTablet.getResourceLocation(item));
            ALLOW_LIST.set(newList);
            return true;
        }

        public static boolean removeItem(Item item) {
            if (item.equals(Items.f_41852_)) {
                return false;
            }
            if (!DimTablet.containItem(item)) {
                return false;
            }
            ArrayList newList = new ArrayList((Collection)ALLOW_LIST.get());
            newList.remove(DimTablet.getResourceLocation(item));
            ALLOW_LIST.set(newList);
            return true;
        }

        private static String getResourceLocation(Item item) {
            return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).toString();
        }

        private static List<String> allowList() {
            return Stream.of(Items.f_42329_, Items.f_41832_, Items.f_42594_, Items.f_41958_, Items.f_42064_, Items.f_42170_, Items.f_41830_, Items.f_41856_, Items.f_42048_, Items.f_42102_).map(DimTablet::getResourceLocation).toList();
        }
    }
}

