/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.infuser;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.MythicBotany;
import mythicbotany.infuser.InfuserRecipe;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import org.apache.commons.lang3.tuple.Pair;
import org.moddingx.libx.base.tile.BlockEntityBase;
import org.moddingx.libx.base.tile.TickingBlock;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.mana.spark.SparkHelper;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.handler.BotaniaSounds;

public class TileManaInfuser
extends BlockEntityBase
implements SparkAttachable,
ManaReceiver,
TickingBlock {
    private int mana;
    @Nullable
    private transient InfuserRecipe recipe;
    @Nullable
    private ItemStack output;
    private transient int maxMana;
    private transient int fromColor = -1;
    private transient int toColor = -1;

    public TileManaInfuser(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, new Capability[]{BotaniaForgeCapabilities.MANA_RECEIVER, BotaniaForgeCapabilities.SPARK_ATTACHABLE});
    }

    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.hasValidPlatform()) {
            this.recipe = null;
            this.fromColor = -1;
            this.toColor = -1;
            this.mana = 0;
            this.maxMana = 0;
            this.output = null;
            return;
        }
        List<ItemEntity> items = this.getItems();
        items.forEach(MythicBotany.getNetwork()::setItemMagnetImmune);
        List<ItemStack> stacks = items.stream().map(ItemEntity::m_32055_).collect(Collectors.toList());
        if (this.recipe != null && this.output != null) {
            if (this.recipe.result(stacks).m_41619_()) {
                this.recipe = null;
                this.fromColor = -1;
                this.toColor = -1;
                this.maxMana = 0;
                this.output = null;
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                this.m_6596_();
                this.setDispatchable();
            } else if (this.mana >= this.recipe.getManaUsage()) {
                this.recipe = null;
                this.fromColor = -1;
                this.toColor = -1;
                this.mana = 0;
                this.maxMana = 0;
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                items.forEach(ie -> ie.m_142687_(Entity.RemovalReason.DISCARDED));
                ItemEntity outItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, this.output);
                this.f_58857_.m_7967_((Entity)outItem);
                this.f_58857_.m_6263_(null, outItem.m_20185_(), outItem.m_20186_(), outItem.m_20189_(), BotaniaSounds.terrasteelCraft, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.output = null;
                this.m_6596_();
                this.setDispatchable();
            } else {
                items.forEach(ie -> MythicBotany.getNetwork().setItemMagnetImmune((ItemEntity)ie));
            }
        } else {
            Pair<InfuserRecipe, ItemStack> match = InfuserRecipe.getOutput(this.f_58857_, stacks);
            if (match != null) {
                this.recipe = (InfuserRecipe)match.getLeft();
                this.mana = Mth.m_14045_((int)this.mana, (int)0, (int)this.recipe.getManaUsage());
                this.maxMana = this.recipe.getManaUsage();
                this.fromColor = this.recipe.fromColor();
                this.toColor = this.recipe.toColor();
                this.output = (ItemStack)match.getRight();
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                this.m_6596_();
                this.setDispatchable();
            } else if (this.recipe != null || this.output != null) {
                this.recipe = null;
                this.fromColor = -1;
                this.toColor = -1;
                this.maxMana = 0;
                this.output = null;
                this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
                this.m_6596_();
                this.setDispatchable();
            }
        }
        if (this.recipe != null) {
            this.receiveManaFromSparks();
            if (this.mana > 0) {
                MythicBotany.getNetwork().spawnInfusionParticles(this.f_58857_, this.f_58858_, (float)this.mana / (float)this.recipe.getManaUsage(), this.recipe.fromColor(), this.recipe.toColor());
            }
        }
    }

    private List<ItemEntity> getItems() {
        return this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1)));
    }

    private boolean hasValidPlatform() {
        BlockPos center = this.f_58858_.m_7495_();
        return this.f_58857_.m_8055_(center).m_60734_() == BotaniaBlocks.shimmerrock && this.f_58857_.m_8055_(center.m_122012_().m_122024_()).m_60734_() == BotaniaBlocks.shimmerrock && this.f_58857_.m_8055_(center.m_122012_().m_122029_()).m_60734_() == BotaniaBlocks.shimmerrock && this.f_58857_.m_8055_(center.m_122019_().m_122024_()).m_60734_() == BotaniaBlocks.shimmerrock && this.f_58857_.m_8055_(center.m_122019_().m_122029_()).m_60734_() == BotaniaBlocks.shimmerrock && this.f_58857_.m_8055_(center.m_122012_()).m_60734_() == Blocks.f_50074_ && this.f_58857_.m_8055_(center.m_122029_()).m_60734_() == Blocks.f_50074_ && this.f_58857_.m_8055_(center.m_122019_()).m_60734_() == Blocks.f_50074_ && this.f_58857_.m_8055_(center.m_122024_()).m_60734_() == Blocks.f_50074_;
    }

    private void receiveManaFromSparks() {
        ManaSpark spark = this.getAttachedSpark();
        if (this.f_58857_ != null && spark != null) {
            List otherSparks = SparkHelper.getSparksAround((Level)this.f_58857_, (double)((double)this.m_58899_().m_123341_() + 0.5), (double)((double)this.m_58899_().m_123342_() + 0.5), (double)((double)this.m_58899_().m_123343_() + 0.5), (DyeColor)spark.getNetwork());
            for (ManaSpark otherSpark : otherSparks) {
                if (spark == otherSpark || !(otherSpark.getAttachedManaReceiver() instanceof ManaPool)) continue;
                otherSpark.registerTransfer(spark);
            }
        }
    }

    public boolean canAttachSpark(ItemStack itemStack) {
        return true;
    }

    public int getAvailableSpaceForMana() {
        if (this.recipe != null) {
            return Math.max(0, this.recipe.getManaUsage() - this.mana);
        }
        return 0;
    }

    public ManaSpark getAttachedSpark() {
        if (this.f_58857_ == null) {
            return null;
        }
        List sparks = this.f_58857_.m_6443_(Entity.class, new AABB(this.f_58858_.m_7494_(), this.f_58858_.m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return this.recipe == null;
    }

    public boolean isFull() {
        if (this.recipe == null) {
            return true;
        }
        return this.mana >= this.recipe.getManaUsage();
    }

    public void receiveMana(int mana) {
        if (this.recipe != null) {
            this.mana = Mth.m_14045_((int)(this.mana + mana), (int)0, (int)this.recipe.getManaUsage());
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.m_6596_();
            this.setDispatchable();
        }
    }

    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    public boolean canReceiveManaFromBursts() {
        return this.recipe != null;
    }

    public int getCurrentMana() {
        return this.recipe != null ? this.mana : 0;
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.mana = nbt.m_128451_("mana");
        this.output = nbt.m_128441_("output") ? ItemStack.m_41712_((CompoundTag)nbt.m_128469_("output")) : null;
    }

    public void m_183515_(@Nonnull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("mana", this.mana);
        if (this.output != null) {
            nbt.m_128365_("output", (Tag)this.output.m_41739_(new CompoundTag()));
        }
    }

    @Nonnull
    public CompoundTag m_5995_() {
        if (this.f_58857_.f_46443_) {
            return super.m_5995_();
        }
        CompoundTag compound = super.m_5995_();
        compound.m_128405_("mana", this.mana);
        if (this.recipe != null) {
            compound.m_128405_("maxMana", this.maxMana);
            compound.m_128405_("fromColor", this.fromColor);
            compound.m_128405_("toColor", this.toColor);
        } else {
            compound.m_128405_("maxMana", 0);
            compound.m_128405_("fromColor", -1);
            compound.m_128405_("toColor", -1);
        }
        return compound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        if (!this.f_58857_.f_46443_) {
            return;
        }
        this.mana = tag.m_128451_("mana");
        this.maxMana = tag.m_128451_("maxMana");
        this.fromColor = tag.m_128451_("fromColor");
        this.toColor = tag.m_128451_("toColor");
    }

    public int getSourceColor() {
        return this.fromColor;
    }

    public int getTargetColor() {
        return this.toColor;
    }

    public double getProgress() {
        if (this.maxMana <= 0) {
            return -1.0;
        }
        return (double)this.mana / (double)this.maxMana;
    }
}

