/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.voiding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.menu.BackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.FilterSlotItemHandler;
import com.tiviacz.travelersbackpack.inventory.menu.slot.TrashSlot;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.voiding.VoidWidget;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class VoidUpgrade
extends FilterUpgradeBase<VoidUpgrade, VoidFilterSettings>
implements IEnable {
    public VoidUpgrade(UpgradeManager manager, int dataHolderSlot, NonNullList<ItemStack> filter, List<String> filterTags) {
        super(manager, dataHolderSlot, new Point(66, 103), (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get(), filter, filterTags);
    }

    @Override
    public List<Integer> getFilter() {
        List<Integer> filter = NbtHelper.getOrDefault(this.getUpgradeManager().getUpgradesHandler().getStackInSlot(this.dataHolderSlot), "FilterSettings", List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1)));
        if (filter.size() != 3) {
            filter = List.of(Integer.valueOf(0), Integer.valueOf(0), Integer.valueOf(1));
        }
        return filter;
    }

    @Override
    public VoidFilterSettings createFilterSettings(UpgradeManager manager, NonNullList<ItemStack> filter, List<String> filterTags) {
        return new VoidFilterSettings(manager.getWrapper().getStorage(), filter.stream().skip(1L).limit(this.getFilterSlotCount()).filter(stack -> !stack.m_41619_()).toList(), this.getFilter(), filterTags);
    }

    public boolean canVoid(ItemStack stack) {
        return ((VoidFilterSettings)this.getFilterSettings()).matchesFilter(null, stack) && this.isEnabled(this);
    }

    @Override
    public ItemStack getFirstFilterStack() {
        return this.filter.getStackInSlot(1);
    }

    public ItemStack getTrashSlotStack() {
        return this.filter.getStackInSlot(0);
    }

    public void voidTrashSlotStack() {
        this.filter.setStackInSlot(0, ItemStack.f_41583_.m_41777_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new VoidWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    public List<Slot> getUpgradeSlots(final BackpackBaseMenu menu, BackpackWrapper wrapper, int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        int activeSlotCount = (Integer)TravelersBackpackConfig.SERVER.backpackUpgrades.voidUpgradeSettings.filterSlotCount.get();
        if (this.isTagSelector()) {
            slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, 1, x + 64, y + 23, 2){

                @Override
                public boolean m_6659_() {
                    return super.m_6659_();
                }

                @Override
                public boolean m_5857_(ItemStack pStack) {
                    return menu.getWrapper().isOwner(menu.player) && super.m_5857_(pStack);
                }
            });
        } else {
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (j + i * 3 == 0) {
                        slots.add((Slot)new TrashSlot(this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount));
                        continue;
                    }
                    slots.add((Slot)new FilterSlotItemHandler(this, (IItemHandler)this.filter, j + i * 3, x + 7 + j * 18, y + 44 + i * 18, activeSlotCount){

                        @Override
                        public boolean m_6659_() {
                            return super.m_6659_() && VoidUpgrade.this.getFilter().get(0) != 2;
                        }

                        @Override
                        public boolean m_5857_(ItemStack pStack) {
                            return menu.getWrapper().isOwner(menu.player) && super.m_5857_(pStack);
                        }
                    });
                }
            }
        }
        return slots;
    }

    @Override
    protected ItemStackHandler createFilter(NonNullList<ItemStack> stacks) {
        return new ItemStackHandler(stacks){

            protected void onContentsChanged(int slot) {
                VoidUpgrade.this.updateDataHolderUnchecked("Inventory", VoidUpgrade.this.filter);
                ((VoidFilterSettings)VoidUpgrade.this.getFilterSettings()).updateFilter((List)NbtHelper.get(VoidUpgrade.this.getDataHolderStack(), "Inventory"));
                ((VoidFilterSettings)VoidUpgrade.this.getFilterSettings()).updateFilterTags((List)NbtHelper.get(VoidUpgrade.this.getDataHolderStack(), "FilterTags"));
                VoidUpgrade.this.changeListeners.forEach(Runnable::run);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return 64;
                }
                return 1;
            }
        };
    }
}

