/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.mojang.datafixers.util.Pair;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundSyncCapabilityPacket {
    private final int entityID;
    private final ItemStack backpack;
    private final boolean removeData;

    public ClientboundSyncCapabilityPacket(int entityID, ItemStack serverBackpack) {
        this(entityID, serverBackpack, false);
    }

    public ClientboundSyncCapabilityPacket(int entityID, ItemStack backpack, boolean removeData) {
        this.entityID = entityID;
        ItemStack backpackCopy = backpack.m_41777_();
        if (backpackCopy.m_41782_()) {
            backpackCopy.m_41783_().m_128473_("Inventory");
        }
        if (backpackCopy.m_41782_() && backpackCopy.m_41783_().m_128441_("MemorySlots")) {
            List memorizedStacksHeavy = (List)NbtHelper.get(backpackCopy, "MemorySlots");
            ArrayList<Pair> reduced = new ArrayList<Pair>();
            for (Pair outerPair : memorizedStacksHeavy) {
                int index = (Integer)outerPair.getFirst();
                ItemStack innerStack = ((ItemStack)((Pair)outerPair.getSecond()).getFirst()).m_41777_();
                boolean matchComponents = (Boolean)((Pair)outerPair.getSecond()).getSecond();
                if (matchComponents) {
                    innerStack = new ItemStack((ItemLike)innerStack.m_41720_(), innerStack.m_41613_());
                }
                if (innerStack.m_41619_()) continue;
                reduced.add(Pair.of((Object)index, (Object)Pair.of((Object)innerStack, (Object)matchComponents)));
            }
            NbtHelper.set(backpack, "MemorySlots", reduced);
        }
        this.backpack = backpackCopy;
        this.removeData = removeData;
    }

    public static ClientboundSyncCapabilityPacket decode(FriendlyByteBuf buffer) {
        int entityID = buffer.readInt();
        ItemStack backpack = buffer.m_130267_();
        boolean removeData = buffer.readBoolean();
        return new ClientboundSyncCapabilityPacket(entityID, backpack, removeData);
    }

    public static void encode(ClientboundSyncCapabilityPacket message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityID);
        buffer.m_130055_(message.backpack);
        buffer.writeBoolean(message.removeData);
    }

    public static void handle(ClientboundSyncCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Player playerEntity = (Player)Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
            LazyOptional<ITravelersBackpack> data = CapabilityUtils.getCapability(playerEntity);
            if (data.isPresent()) {
                if (message.removeData) {
                    ((ITravelersBackpack)data.resolve().get()).remove();
                } else {
                    ((ITravelersBackpack)data.resolve().get()).updateBackpack(message.backpack);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

