/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import com.google.common.primitives.Ints;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockEntityFireworkGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private FireworkRocketEntity trackedEntity;
    private ItemStack trackedItem;
    private int toRelease;
    private int releaseTimer;

    public BlockEntityFireworkGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FIREWORK_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 10L == 0L) {
                List items = this.f_58857_.m_6443_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(4.0), Entity::m_6084_);
                for (ItemEntity item : items) {
                    ItemStack stack;
                    if (item.m_32063_() || (stack = item.m_32055_()).m_41619_() || stack.m_41720_() != Items.f_42688_) continue;
                    if (this.trackedEntity == null && this.releaseTimer <= 0) {
                        FireworkRocketEntity entity;
                        this.trackedEntity = entity = new FireworkRocketEntity(this.f_58857_, item.m_20185_(), item.m_20186_(), item.m_20189_(), stack);
                        this.trackedItem = stack.m_41777_();
                        this.f_58857_.m_7967_((Entity)entity);
                    }
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        item.m_6074_();
                        continue;
                    }
                    item.m_32045_(stack);
                }
            }
            if (this.trackedEntity != null && !this.trackedEntity.m_6084_()) {
                if (this.trackedItem.m_41782_()) {
                    float generateFactor = 0.0f;
                    HashSet<Integer> usedColors = new HashSet<Integer>();
                    CompoundTag compound = this.trackedItem.m_41783_();
                    CompoundTag fireworks = compound.m_128469_("Fireworks");
                    int flightTime = fireworks.m_128451_("Flight");
                    ListTag explosions = fireworks.m_128437_("Explosions", 10);
                    if (!explosions.isEmpty()) {
                        generateFactor += (float)flightTime;
                        for (Tag base : explosions) {
                            boolean trail;
                            CompoundTag explosion = (CompoundTag)base;
                            generateFactor += 1.5f;
                            boolean flicker = explosion.m_128471_("Flicker");
                            if (flicker) {
                                generateFactor += 1.0f;
                            }
                            if (trail = explosion.m_128471_("Trail")) {
                                generateFactor += 8.0f;
                            }
                            byte type = explosion.m_128445_("Type");
                            generateFactor += (new float[]{0.0f, 1.0f, 0.5f, 20.0f, 0.5f})[type];
                            HashSet<Integer> colors = new HashSet<Integer>();
                            for (int color : explosion.m_128465_("Colors")) {
                                usedColors.add(color);
                                colors.add(color);
                            }
                            generateFactor += 0.75f * (float)colors.size();
                        }
                    }
                    if (generateFactor > 0.0f) {
                        int toAdd = Mth.m_14167_((float)(generateFactor * 10000.0f));
                        if (this.canGenerateRightNow(toAdd)) {
                            this.toRelease = toAdd;
                            this.releaseTimer = 15 * flightTime + 40;
                        }
                        ArrayList<Integer> data = new ArrayList<Integer>();
                        data.add(this.f_58858_.m_123341_());
                        data.add(this.f_58858_.m_123342_());
                        data.add(this.f_58858_.m_123343_());
                        data.addAll(usedColors);
                        PacketHandler.sendToAllLoaded(this.f_58857_, this.f_58858_, new PacketParticles((float)this.trackedEntity.m_20185_(), (float)this.trackedEntity.m_20186_(), (float)this.trackedEntity.m_20189_(), PacketParticles.Type.FIREWORK_GEN, Ints.toArray(data)));
                    }
                }
                this.trackedEntity = null;
                this.trackedItem = null;
            }
            if (this.releaseTimer > 0) {
                --this.releaseTimer;
                if (this.releaseTimer <= 0) {
                    this.generateAura(this.toRelease);
                    this.toRelease = 0;
                    PacketHandler.sendToAllLoaded(this.f_58857_, this.f_58858_, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.FLOWER_GEN_AURA_CREATION, new int[0]));
                }
            }
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }
}

