/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.multiblock.IMultiblock;
import de.ellpeck.naturesaura.items.ItemImpl;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class ItemMultiblockMaker
extends ItemImpl {
    private static List<IMultiblock> multiblocks;

    public ItemMultiblockMaker() {
        super("multiblock_maker");
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (!levelIn.f_46443_ && playerIn.m_7500_()) {
            int curr = ItemMultiblockMaker.getMultiblockId(stack);
            int next = (curr + 1) % ItemMultiblockMaker.multiblocks().size();
            stack.m_41784_().m_128405_("multiblock", next);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        if (player.m_7500_()) {
            IMultiblock multi = ItemMultiblockMaker.getMultiblock(player.m_21120_(context.m_43724_()));
            if (multi == null) {
                return InteractionResult.PASS;
            }
            if (!context.m_43725_().f_46443_) {
                multi.forEach(context.m_8083_().m_7494_(), '\u0000', (blockPos, matcher) -> {
                    context.m_43725_().m_46597_(blockPos, matcher.defaultState());
                    return true;
                });
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Component m_7626_(ItemStack stack) {
        MutableComponent name = (MutableComponent)super.m_7626_(stack);
        IMultiblock multi = ItemMultiblockMaker.getMultiblock(stack);
        return multi == null ? name : name.m_130946_(" (" + multi.getName() + ")");
    }

    private static List<IMultiblock> multiblocks() {
        if (multiblocks == null) {
            if (NaturesAuraAPI.MULTIBLOCKS.isEmpty()) {
                return null;
            }
            multiblocks = new ArrayList<IMultiblock>();
            multiblocks.addAll(NaturesAuraAPI.MULTIBLOCKS.values());
        }
        return multiblocks;
    }

    private static int getMultiblockId(ItemStack stack) {
        if (!stack.m_41782_()) {
            return -1;
        }
        return stack.m_41783_().m_128451_("multiblock");
    }

    private static IMultiblock getMultiblock(ItemStack stack) {
        List<IMultiblock> multiblocks = ItemMultiblockMaker.multiblocks();
        if (multiblocks == null) {
            return null;
        }
        int id = ItemMultiblockMaker.getMultiblockId(stack);
        if (id < 0 || id >= multiblocks.size()) {
            return null;
        }
        return multiblocks.get(id);
    }
}

