/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.block;

import java.util.Optional;
import java.util.Set;
import mod.motivationaldragon.potionblender.blockentities.BrewingCauldronBlockEntity;
import mod.motivationaldragon.potionblender.config.ConfigController;
import mod.motivationaldragon.potionblender.platform.Service;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrewingCauldron
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HAS_FLUID = BooleanProperty.m_61465_((String)"has_fluid");
    public static final BooleanProperty IS_BREWING = BooleanProperty.m_61465_((String)"is_brewing");
    public static final BooleanProperty IS_SOULFIRE = BooleanProperty.m_61465_((String)"soulfire");
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    private static final VoxelShape INSIDE = BrewingCauldron.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83144_(), (VoxelShape)Shapes.m_83124_((VoxelShape)BrewingCauldron.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{BrewingCauldron.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), BrewingCauldron.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (BooleanOp)BooleanOp.f_82685_);
    Set<Item> dowseItems = Set.of(ConfigController.getConfig().getDowsingItems());
    Set<Item> litItems = Set.of(ConfigController.getConfig().getLitItems());

    public BrewingCauldron(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HAS_FLUID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)IS_BREWING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true))).m_61124_((Property)IS_SOULFIRE, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HAS_FLUID, FACING, IS_BREWING, LIT, IS_SOULFIRE});
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return BrewingCauldron.m_152132_(type, Service.PLATFORM.getPlatformBrewingCauldron(), BrewingCauldronBlockEntity::tick);
    }

    public void m_6810_(BlockState state, Level level, BlockPos blockPos, BlockState newState, boolean b) {
        if (!level.m_5776_() && state.m_60734_() != newState.m_60734_()) {
            BrewingCauldron.tryGetBlockEntity(level, blockPos).ifPresent(brewingCauldronBlockEntity -> Containers.m_19010_((Level)level, (BlockPos)blockPos, brewingCauldronBlockEntity.getInventory()));
        }
        super.m_6810_(state, level, blockPos, state, b);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (!world.m_5776_()) {
            if (this.dowseItems.contains(player.m_21120_(hand).m_41720_()) || player.m_21205_().m_41720_() instanceof ShovelItem) {
                BrewingCauldron.dowse(world, pos);
                return InteractionResult.CONSUME;
            }
            if (this.litItems.contains(player.m_21120_(hand).m_41720_()) && !((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                BrewingCauldron.ignite(state, world, pos);
                return InteractionResult.CONSUME;
            }
            BrewingCauldron.tryGetBlockEntity(world, pos).ifPresent(brewingCauldronBlockEntity -> brewingCauldronBlockEntity.onUseDelegate(state, world, pos, player));
        }
        return InteractionResult.SUCCESS;
    }

    private static void ignite(@NotNull BlockState state, Level world, @NotNull BlockPos pos) {
        world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
        world.m_5594_(null, pos, SoundEvents.f_11874_, SoundSource.BLOCKS, 1.0f, 1.0f);
        CampfireBlock.m_51251_((Level)world, (BlockPos)pos, (boolean)false, (boolean)true);
        BrewingCauldron.tryGetBlockEntity(world, pos).ifPresent(BrewingCauldronBlockEntity::markUpdated);
    }

    public static void dowse(Level world, @NotNull BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
            world.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            BrewingCauldron.tryGetBlockEntity(world, pos).ifPresent(BrewingCauldronBlockEntity::markUpdated);
        }
    }

    @NotNull
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
    }

    public void m_214162_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            BrewingCauldron.createDisplayParticles(world, pos, random, (Direction)state.m_61143_((Property)FACING), (ParticleOptions)ParticleTypes.f_123762_);
            BrewingCauldron.createDisplayParticles(world, pos, random, ((Direction)state.m_61143_((Property)FACING)).m_122424_(), (ParticleOptions)ParticleTypes.f_123762_);
            if (random.m_188503_(10) == 0) {
                world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
            }
        }
        if (((Boolean)state.m_61143_((Property)HAS_FLUID)).booleanValue()) {
            Optional<BrewingCauldronBlockEntity> brewingCauldronBlockEntity = BrewingCauldron.tryGetBlockEntity(world, pos);
            if (brewingCauldronBlockEntity.isEmpty()) {
                return;
            }
            int color = brewingCauldronBlockEntity.get().getWaterColor();
            DustParticleOptions coloredSmoke = new DustParticleOptions(Vec3.m_82501_((int)color).m_252839_(), 1.0f);
            float x = (float)pos.m_123341_() + (float)random.m_216332_(2, 8) / 10.0f;
            float z = (float)pos.m_123343_() + (float)random.m_216332_(2, 8) / 10.0f;
            world.m_7106_((ParticleOptions)coloredSmoke, (double)x, (double)pos.m_123342_() + 1.0, (double)z, 0.0, 0.0, 0.0);
            if (((Boolean)state.m_61143_((Property)IS_BREWING)).booleanValue() && ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                x = (float)pos.m_123341_() + (float)random.m_216332_(2, 8) / 10.0f;
                z = (float)pos.m_123343_() + (float)random.m_216332_(2, 8) / 10.0f;
                world.m_7106_((ParticleOptions)ParticleTypes.f_123777_, (double)x, (double)pos.m_123342_() + 1.0, (double)z, 0.0, 0.07, 0.0);
                SimpleParticleType particles = (Boolean)state.m_61143_((Property)IS_SOULFIRE) != false ? ParticleTypes.f_123745_ : ParticleTypes.f_123744_;
                BrewingCauldron.createDisplayParticles(world, pos, random, (Direction)state.m_61143_((Property)FACING), (ParticleOptions)particles);
                BrewingCauldron.createDisplayParticles(world, pos, random, ((Direction)state.m_61143_((Property)FACING)).m_122424_(), (ParticleOptions)particles);
                for (int i = 0; i < 10; ++i) {
                    x = (float)pos.m_123341_() + (float)random.m_216332_(2, 8) / 10.0f;
                    z = (float)pos.m_123343_() + (float)random.m_216332_(2, 8) / 10.0f;
                    world.m_7106_((ParticleOptions)coloredSmoke, (double)x, (double)pos.m_123342_() + 1.0, (double)z, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    private static void createDisplayParticles(Level world, BlockPos pos, RandomSource random, Direction direction, ParticleOptions particleTypes) {
        Direction.Axis axis = direction.m_122434_();
        double xPos = (double)pos.m_123341_() + 0.5;
        double yPos = pos.m_123342_();
        double zPos = (double)pos.m_123343_() + 0.5;
        double h = random.m_188500_() * 0.6 - 0.3;
        double xOffset = axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : h;
        double j = random.m_188500_() * 6.0 / 16.0;
        double zOffset = axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : h;
        world.m_7106_(particleTypes, xPos + xOffset, yPos + j, zPos + zOffset, 0.0, 0.0, 0.0);
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape m_6079_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return INSIDE;
    }

    public void m_142072_(@NotNull Level world, @NotNull BlockState blockState, @NotNull BlockPos pos, Entity entity, float speed) {
        Optional<BrewingCauldronBlockEntity> brewingCauldronBlockEntity = BrewingCauldron.tryGetBlockEntity(entity.m_9236_(), entity.m_20183_());
        if (brewingCauldronBlockEntity.isPresent() && !entity.m_9236_().m_5776_()) {
            brewingCauldronBlockEntity.get().onEntityLandDelegate(entity);
        }
        super.m_142072_(world, blockState, pos, entity, speed);
    }

    private static Optional<BrewingCauldronBlockEntity> tryGetBlockEntity(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof BrewingCauldronBlockEntity) {
            BrewingCauldronBlockEntity alchemyMixerBlockEntity = (BrewingCauldronBlockEntity)blockEntity;
            return Optional.of(alchemyMixerBlockEntity);
        }
        return Optional.empty();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return Service.PLATFORM.createPlatformBrewingCauldronBlockEntity(pos, state);
    }
}

