/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.mixins;

import mod.motivationaldragon.potionblender.utils.ModUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionItem.class})
public abstract class PotionItemMixin {
    @Inject(method={"getDescriptionId*"}, at={@At(value="RETURN")}, cancellable=true)
    private void getDescriptionId(ItemStack stack, CallbackInfoReturnable<String> cir) {
        CompoundTag nbtCompound = stack.m_41783_();
        if (nbtCompound != null) {
            if (ModUtils.isTagValueTrue(nbtCompound, "potionblender_IsCombinedPotion")) {
                cir.setReturnValue((Object)"Combined Potion");
            } else if (ModUtils.isTagValueTrue(nbtCompound, "potionblender_IsCombinedSplashPotion")) {
                cir.setReturnValue((Object)"Combined Splash Potion");
            } else if (ModUtils.isTagValueTrue(nbtCompound, "potionblender_IsCombinedLingeringPotion")) {
                cir.setReturnValue((Object)"Combined Lingering Potion");
            }
        }
    }
}

