/*
 * Decompiled with CFR 0.152.
 */
package mod.motivationaldragon.potionblender.networking;

import mod.motivationaldragon.potionblender.blockentities.BrewingCauldronBlockEntity;
import mod.motivationaldragon.potionblender.networking.PotionBlenderPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public record BrewingCauldronInvSyncS2CPacket(NonNullList<ItemStack> inv, BlockPos containerLocation) implements PotionBlenderPacket
{
    public static final ResourceLocation fabricChannel = new ResourceLocation("potionblender", "brewing_cauldron_sync_inv");

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.inv.size());
        for (ItemStack item : this.inv) {
            buf.m_130055_(item);
        }
        buf.m_130064_(this.containerLocation);
    }

    public static void handle(BrewingCauldronInvSyncS2CPacket packet) {
        BlockPos containerLocation = packet.containerLocation();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null || level.m_46805_(containerLocation)) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(containerLocation);
        if (blockEntity instanceof BrewingCauldronBlockEntity) {
            BrewingCauldronBlockEntity blockEntity2 = (BrewingCauldronBlockEntity)blockEntity;
            blockEntity2.setInventory(packet.inv);
        }
    }

    @Override
    public ResourceLocation getFabricId() {
        return fabricChannel;
    }

    public static BrewingCauldronInvSyncS2CPacket decode(FriendlyByteBuf buf) {
        int size = buf.readInt();
        NonNullList list = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        for (int i = 0; i < size; ++i) {
            list.set(i, (Object)buf.m_130267_());
        }
        return new BrewingCauldronInvSyncS2CPacket((NonNullList<ItemStack>)list, buf.m_130135_());
    }
}

