/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;

public class IEItemFluidHandler
extends FluidHandlerItemStack {
    public static Component fluidItemInfoFlavor(@Nullable FluidStack fluid, int fluidCapacity) {
        if (fluid != null && fluid.getAmount() > 0) {
            FluidType attr = fluid.getFluid().getFluidType();
            ChatFormatting rarity = attr.getRarity() == Rarity.COMMON ? ChatFormatting.GRAY : attr.getRarity().f_43022_;
            return TextUtils.applyFormat((Component)Component.m_237110_((String)"desc.immersiveengineering.flavour.fluidStack", (Object[])new Object[]{fluid.getDisplayName(), fluid.getAmount(), fluidCapacity}), rarity);
        }
        return TextUtils.applyFormat((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.drill.empty"), ChatFormatting.GRAY);
    }

    public IEItemFluidHandler(ItemStack container, int capacity) {
        super(container, capacity);
    }

    public int getCapacity() {
        if (this.container.m_41720_() instanceof IEItemInterfaces.IAdvancedFluidItem) {
            return ((IEItemInterfaces.IAdvancedFluidItem)this.container.m_41720_()).getCapacity(this.container, this.capacity);
        }
        return this.capacity;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        if (this.container.m_41720_() instanceof IEItemInterfaces.IAdvancedFluidItem) {
            return ((IEItemInterfaces.IAdvancedFluidItem)this.container.m_41720_()).allowFluid(this.container, fluid);
        }
        return true;
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack fluid) {
        FluidStack tankFluid = this.getFluidInTank(tank);
        return tankFluid.isEmpty() && this.canFillFluidType(fluid) || tankFluid.isFluidEqual(fluid);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (this.container.m_41613_() != 1 || resource.isEmpty() || !this.canFillFluidType(resource)) {
            return 0;
        }
        FluidStack contained = this.getFluid();
        if (contained.isEmpty()) {
            int fillAmount = Math.min(this.getCapacity(), resource.getAmount());
            if (doFill.execute()) {
                FluidStack filled = resource.copy();
                filled.setAmount(fillAmount);
                this.setFluid(filled);
            }
            return fillAmount;
        }
        if (contained.isFluidEqual(resource)) {
            int fillAmount = Math.min(this.getCapacity() - contained.getAmount(), resource.getAmount());
            if (doFill.execute() && fillAmount > 0) {
                contained.grow(fillAmount);
                this.setFluid(contained);
            }
            return fillAmount;
        }
        return 0;
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }
}

