/*
 * Decompiled with CFR 0.152.
 */
package malte0811.modelsplitter.math;

import com.google.common.base.Preconditions;
import malte0811.modelsplitter.math.ModelSplitterVec3i;

public record Vec3d(double x, double y, double z) {
    public static final Vec3d ZERO = new Vec3d(0.0, 0.0, 0.0);

    public Vec3d {
        Preconditions.checkArgument((boolean)Double.isFinite(x));
        Preconditions.checkArgument((boolean)Double.isFinite(y));
        Preconditions.checkArgument((boolean)Double.isFinite(z));
    }

    public Vec3d(double[] coords) {
        this(coords[0], coords[1], coords[2]);
    }

    public Vec3d(ModelSplitterVec3i vec) {
        this(vec.x(), vec.y(), vec.z());
    }

    public double dotProduct(Vec3d other) {
        double ret = 0.0;
        for (int i = 0; i < 3; ++i) {
            ret += this.get(i) * other.get(i);
        }
        return ret;
    }

    public double get(int index) {
        return switch (index) {
            case 0 -> this.x;
            case 1 -> this.y;
            case 2 -> this.z;
            default -> throw new IllegalStateException("Unexpected index in Vec3d: " + index);
        };
    }

    public Vec3d normalize() {
        double length = this.length();
        if (length < 1.0E-4) {
            return this;
        }
        return this.scale(1.0 / length);
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        double ret = 0.0;
        for (int i = 0; i < 3; ++i) {
            ret += this.get(i) * this.get(i);
        }
        return ret;
    }

    public Vec3d scale(double lambda) {
        return new Vec3d(this.get(0) * lambda, this.get(1) * lambda, this.get(2) * lambda);
    }

    public Vec3d add(Vec3d other) {
        return new Vec3d(this.get(0) + other.get(0), this.get(1) + other.get(1), this.get(2) + other.get(2));
    }

    public Vec3d subtract(Vec3d other) {
        return new Vec3d(this.get(0) - other.get(0), this.get(1) - other.get(1), this.get(2) - other.get(2));
    }

    public Vec3d crossProduct(Vec3d other) {
        return new Vec3d(this.y * other.z - this.z * other.y, this.z * other.x - this.x * other.z, this.x * other.y - this.y * other.x);
    }
}

