/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.Tesselator;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public final class StencilBufferUtil {
    private StencilBufferUtil() {
    }

    public static void setup(int index) {
        Minecraft.m_91087_().m_91385_().enableStencil();
        RenderSystem.enableBlend();
        StencilBufferUtil.invisibleBlend();
        StencilBufferUtil.enableStencil(index);
    }

    public static void finish() {
        StencilBufferUtil.disableStencil();
        RenderSystem.defaultBlendFunc();
    }

    public static void setup(int index, Runnable run) {
        StencilBufferUtil.setup(index);
        run.run();
        StencilBufferUtil.finish();
    }

    public static void startRender(int index) {
        GL11.glEnable((int)2960);
        RenderSystem.stencilFunc((int)514, (int)index, (int)255);
    }

    public static void endRenderAndFinish(int index) {
        StencilBufferUtil.endRender(index);
        StencilBufferUtil.finishRender();
    }

    public static void render(int index, Runnable run, boolean flush) {
        StencilBufferUtil.startRender(index);
        run.run();
        if (flush) {
            StencilBufferUtil.endRenderAndFinish(index);
        } else {
            StencilBufferUtil.endRender(index);
        }
    }

    public static void render(int index, Runnable run) {
        StencilBufferUtil.render(index, run, false);
    }

    public static void renderAndFlush(int index, Runnable run) {
        StencilBufferUtil.render(index, run, true);
    }

    public static void renderTesselator(int index) {
        StencilBufferUtil.render(index, () -> Tesselator.m_85913_().m_85914_());
    }

    public static void renderTesselatorAndFlush(int index) {
        StencilBufferUtil.renderAndFlush(index, () -> Tesselator.m_85913_().m_85914_());
    }

    public static void endRender(int index) {
        RenderSystem.stencilFunc((int)519, (int)index, (int)255);
    }

    public static void finishRender() {
        RenderSystem.stencilMask((int)255);
        RenderSystem.clear((int)1024, (boolean)Minecraft.f_91002_);
        RenderSystem.stencilMask((int)0);
        GL11.glDisable((int)2960);
    }

    public static void enableStencil(int index) {
        Minecraft.m_91087_().m_91385_().enableStencil();
        GL11.glEnable((int)2960);
        RenderSystem.stencilMask((int)255);
        RenderSystem.stencilFunc((int)519, (int)index, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7681);
    }

    public static void disableStencil() {
        RenderSystem.stencilFunc((int)519, (int)0, (int)255);
        RenderSystem.stencilOp((int)7680, (int)7680, (int)7680);
        RenderSystem.stencilMask((int)0);
        GL11.glDisable((int)2960);
    }

    public static void invisibleBlend() {
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }
}

