/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AECheckbox;
import appeng.menu.AEBaseMenu;
import appeng.menu.ISubMenu;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEColorPicker;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIcon;
import net.pedroksl.advanced_ae.client.gui.widgets.AAEIconButton;
import net.pedroksl.advanced_ae.common.definitions.AAESlotSemantics;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.AAEColor;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.gui.QuantumArmorStyleConfigMenu;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.quantumarmor.QuantumArmorStylePacket;

public class QuantumArmorStyleConfigScreen
extends AEBaseScreen<QuantumArmorStyleConfigMenu> {
    private int selectedIndex = 0;
    private boolean applyToAll = true;
    private final AAEColorPicker colorPicker;
    private final AECheckbox checkBox;
    private final ConfirmButton confirmButton;

    public QuantumArmorStyleConfigScreen(QuantumArmorStyleConfigMenu menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super((AEBaseMenu)menu, playerInventory, title, style);
        AESubScreen.addBackButton((ISubMenu)menu, (String)"back", (WidgetContainer)this.widgets);
        this.colorPicker = new AAEColorPicker((arg_0, arg_1) -> ((WidgetContainer)this.widgets).add(arg_0, arg_1), 0, style, "colorPicker");
        this.checkBox = this.widgets.addCheckbox("checkBox", (Component)AAEText.ApplyToAll.text(), this::toggleApplyToAll);
        this.confirmButton = new ConfirmButton(value -> this.confirm());
        this.widgets.add("confirmButton", (AbstractWidget)this.confirmButton);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.selectedIndex = ((QuantumArmorStyleConfigMenu)this.m_6262_()).slotIndex;
        int lastColor = -1;
        for (Slot slot : ((QuantumArmorStyleConfigMenu)this.f_97732_).getSlots(AAESlotSemantics.ARMOR)) {
            Item item;
            if (!slot.m_6657_() || !((item = slot.m_7993_().m_41720_()) instanceof QuantumArmorBase)) continue;
            QuantumArmorBase armor = (QuantumArmorBase)item;
            int color = armor.getTintColor(slot.m_7993_());
            if (lastColor != -1 && lastColor != color) {
                this.applyToAll = false;
                break;
            }
            lastColor = color;
        }
        this.checkBox.setSelected(this.applyToAll);
        this.updateColorPicker();
    }

    public void toggleApplyToAll() {
        this.applyToAll = !this.applyToAll;
    }

    public void updateColorPicker() {
        Item item;
        Slot slot;
        if (this.selectedIndex != -1 && this.selectedIndex < ((QuantumArmorStyleConfigMenu)this.f_97732_).f_38839_.size() && (slot = ((QuantumArmorStyleConfigMenu)this.f_97732_).m_38853_(this.selectedIndex)).m_6657_() && (item = slot.m_7993_().m_41720_()) instanceof QuantumArmorBase) {
            QuantumArmorBase armor = (QuantumArmorBase)item;
            this.colorPicker.setColorAndUpdate(armor.getTintColor(slot.m_7993_()));
        }
    }

    public void confirm() {
        ArrayList<Integer> updateList = new ArrayList<Integer>();
        if (this.applyToAll) {
            for (Slot slot : ((QuantumArmorStyleConfigMenu)this.f_97732_).getSlots(AAESlotSemantics.ARMOR)) {
                if (!slot.m_6657_() || !(slot.m_7993_().m_41720_() instanceof QuantumArmorBase)) continue;
                updateList.add(slot.f_40219_);
            }
        } else {
            Slot slot = ((QuantumArmorStyleConfigMenu)this.f_97732_).m_38853_(this.selectedIndex);
            if (slot.m_6657_() && slot.m_7993_().m_41720_() instanceof QuantumArmorBase) {
                updateList.add(slot.f_40219_);
            }
        }
        AAENetworkHandler.INSTANCE.sendToServer(new QuantumArmorStylePacket(updateList, this.colorPicker.color().argb()));
    }

    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        Slot slot;
        assert (this.f_96541_ != null);
        if (btn == 0 && this.isValidSlot(slot = this.m_97744_(xCoord, yCoord))) {
            if (this.applyToAll) {
                return true;
            }
            this.selectedIndex = slot.f_40219_;
            ((QuantumArmorStyleConfigMenu)this.f_97732_).setSelectedItemSlot(slot.getSlotIndex());
            this.updateColorPicker();
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    private boolean isValidSlot(Slot slot) {
        return slot != null && slot.m_6659_() && slot.m_6657_() && slot.m_7993_().m_41720_() instanceof QuantumArmorBase;
    }

    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        super.drawBG(guiGraphics, offsetX, offsetY, mouseX, mouseY, partialTicks);
        if (this.applyToAll) {
            for (Slot slot : ((QuantumArmorStyleConfigMenu)this.f_97732_).getSlots(AAESlotSemantics.ARMOR)) {
                AEBaseScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(slot.f_40220_ + offsetX), (int)(slot.f_40221_ + offsetY), (int)0, (int)AAEColor.LIGHT_PURPLE.argb());
            }
        } else if (this.selectedIndex != -1 && this.selectedIndex < ((QuantumArmorStyleConfigMenu)this.f_97732_).f_38839_.size()) {
            Slot slot = ((QuantumArmorStyleConfigMenu)this.f_97732_).m_38853_(this.selectedIndex);
            AEBaseScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(slot.f_40220_ + offsetX), (int)(slot.f_40221_ + offsetY), (int)0, (int)AAEColor.LIGHT_PURPLE.argb());
        }
    }

    static class ConfirmButton
    extends AAEIconButton {
        public ConfirmButton(Button.OnPress onPress) {
            super(onPress);
        }

        @Override
        protected AAEIcon getIcon() {
            return AAEIcon.CONFIRM;
        }
    }
}

