/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client;

import java.net.URL;
import mods.railcraft.Translations;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SignalUtil;
import mods.railcraft.client.KeyBinding;
import mods.railcraft.client.TuningAuraHandlerImpl;
import mods.railcraft.client.gui.screen.inventory.BlastFurnaceScreen;
import mods.railcraft.client.gui.screen.inventory.CartDispenserScreen;
import mods.railcraft.client.gui.screen.inventory.CokeOvenScreen;
import mods.railcraft.client.gui.screen.inventory.CreativeLocomotiveScreen;
import mods.railcraft.client.gui.screen.inventory.CrusherScreen;
import mods.railcraft.client.gui.screen.inventory.DumpingTrackScreen;
import mods.railcraft.client.gui.screen.inventory.ElectricLocomotiveScreen;
import mods.railcraft.client.gui.screen.inventory.EnergyMinecartScreen;
import mods.railcraft.client.gui.screen.inventory.FeedStationScreen;
import mods.railcraft.client.gui.screen.inventory.FluidFueledSteamBoilerScreen;
import mods.railcraft.client.gui.screen.inventory.FluidManipulatorScreen;
import mods.railcraft.client.gui.screen.inventory.ItemManipulatorScreen;
import mods.railcraft.client.gui.screen.inventory.ManualRollingMachineScreen;
import mods.railcraft.client.gui.screen.inventory.PoweredRollingMachineScreen;
import mods.railcraft.client.gui.screen.inventory.RoutingDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.RoutingTrackScreen;
import mods.railcraft.client.gui.screen.inventory.SolidFueledSteamBoilerScreen;
import mods.railcraft.client.gui.screen.inventory.SteamLocomotiveScreen;
import mods.railcraft.client.gui.screen.inventory.SteamOvenScreen;
import mods.railcraft.client.gui.screen.inventory.SteamTurbineScreen;
import mods.railcraft.client.gui.screen.inventory.SwitchTrackRouterScreen;
import mods.railcraft.client.gui.screen.inventory.TankMinecartScreen;
import mods.railcraft.client.gui.screen.inventory.TankScreen;
import mods.railcraft.client.gui.screen.inventory.TrackLayerScreen;
import mods.railcraft.client.gui.screen.inventory.TrackRelayerScreen;
import mods.railcraft.client.gui.screen.inventory.TrackUndercutterScreen;
import mods.railcraft.client.gui.screen.inventory.TrainDispenserScreen;
import mods.railcraft.client.gui.screen.inventory.TunnelBoreScreen;
import mods.railcraft.client.gui.screen.inventory.WaterTankSidingScreen;
import mods.railcraft.client.gui.screen.inventory.detector.AdvancedDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.detector.ItemDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.detector.LocomotiveDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.detector.SheepDetectorScreen;
import mods.railcraft.client.gui.screen.inventory.detector.TankDetectorScreen;
import mods.railcraft.client.model.RailcraftLayerDefinitions;
import mods.railcraft.client.particle.ChunkLoaderParticle;
import mods.railcraft.client.particle.FireSparkParticle;
import mods.railcraft.client.particle.ForceSpawnParticle;
import mods.railcraft.client.particle.PumpkinParticle;
import mods.railcraft.client.particle.SparkParticle;
import mods.railcraft.client.particle.SteamParticle;
import mods.railcraft.client.particle.TuningAuraParticle;
import mods.railcraft.client.renderer.ShuntingAuraRenderer;
import mods.railcraft.client.renderer.blockentity.RailcraftBlockEntityRenderers;
import mods.railcraft.client.renderer.entity.RailcraftEntityRenderers;
import mods.railcraft.integrations.patchouli.Patchouli;
import mods.railcraft.particle.RailcraftParticleTypes;
import mods.railcraft.world.inventory.RailcraftMenuTypes;
import mods.railcraft.world.item.GogglesItem;
import mods.railcraft.world.item.LocomotiveItem;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.level.block.ForceTrackEmitterBlock;
import mods.railcraft.world.level.block.RailcraftBlocks;
import mods.railcraft.world.level.block.track.ForceTrackBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class ClientManager {
    private static ShuntingAuraRenderer shuntingAuraRenderer;

    public static void init(IEventBus modEventBus) {
        modEventBus.addListener(ClientManager::handleClientSetup);
        modEventBus.addListener(ClientManager::handleItemColors);
        modEventBus.addListener(ClientManager::handleBlockColors);
        modEventBus.addListener(ClientManager::handleParticleRegistration);
        modEventBus.addListener(ClientManager::handleRegisterRenderers);
        modEventBus.addListener(ClientManager::handleRegisterLayerDefinitions);
        modEventBus.addListener(ClientManager::handleKeyRegister);
        MinecraftForge.EVENT_BUS.register(ClientManager.class);
        shuntingAuraRenderer = new ShuntingAuraRenderer();
        SignalUtil._setTuningAuraHandler(new TuningAuraHandlerImpl());
    }

    public static ShuntingAuraRenderer getShuntingAuraRenderer() {
        return shuntingAuraRenderer;
    }

    private static void handleClientSetup(FMLClientSetupEvent event) {
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.SOLID_FUELED_STEAM_BOILER.get()), SolidFueledSteamBoilerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.FLUID_FUELED_STEAM_BOILER.get()), FluidFueledSteamBoilerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.STEAM_TURBINE.get()), SteamTurbineScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.TANK.get()), TankScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.WATER_TANK_SIDING.get()), WaterTankSidingScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.TRACK_LAYER.get()), TrackLayerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.TRACK_RELAYER.get()), TrackRelayerScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.TRACK_UNDERCUTTER.get()), TrackUndercutterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.BLAST_FURNACE.get()), BlastFurnaceScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.FEED_STATION.get()), FeedStationScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.CREATIVE_LOCOMOTIVE.get()), CreativeLocomotiveScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.ELECTRIC_LOCOMOTIVE.get()), ElectricLocomotiveScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.STEAM_LOCOMOTIVE.get()), SteamLocomotiveScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.MANUAL_ROLLING_MACHINE.get()), ManualRollingMachineScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.POWERED_ROLLING_MACHINE.get()), PoweredRollingMachineScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.COKE_OVEN.get()), CokeOvenScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.CRUSHER.get()), CrusherScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.STEAM_OVEN.get()), SteamOvenScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.ITEM_MANIPULATOR.get()), ItemManipulatorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.FLUID_MANIPULATOR.get()), FluidManipulatorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.CART_DISPENSER.get()), CartDispenserScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.TRAIN_DISPENSER.get()), TrainDispenserScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.TANK_MINECART.get()), TankMinecartScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.ENERGY_MINECART.get()), EnergyMinecartScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.SWITCH_TRACK_ROUTER.get()), SwitchTrackRouterScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.TUNNEL_BORE.get()), TunnelBoreScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.ROUTING_TRACK.get()), RoutingTrackScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.DUMPING_TRACK.get()), DumpingTrackScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.SHEEP_DETECTOR.get()), SheepDetectorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.LOCOMOTIVE_DETECTOR.get()), LocomotiveDetectorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.TANK_DETECTOR.get()), TankDetectorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.ADVANCED_DETECTOR.get()), AdvancedDetectorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.ITEM_DETECTOR.get()), ItemDetectorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)RailcraftMenuTypes.ROUTING_DETECTOR.get()), RoutingDetectorScreen::new);
        if (ModList.get().isLoaded("patchouli")) {
            Patchouli.setup();
        }
    }

    private static void handleItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> switch (tintIndex) {
            case 0 -> LocomotiveItem.getPrimaryColor((ItemStack)stack).m_284406_().f_283871_;
            case 1 -> LocomotiveItem.getSecondaryColor((ItemStack)stack).m_284406_().f_283871_;
            default -> -1;
        }, new ItemLike[]{(ItemLike)RailcraftItems.CREATIVE_LOCOMOTIVE.get(), (ItemLike)RailcraftItems.STEAM_LOCOMOTIVE.get(), (ItemLike)RailcraftItems.ELECTRIC_LOCOMOTIVE.get()});
    }

    private static void handleBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> ((DyeColor)state.m_61143_(ForceTrackEmitterBlock.COLOR)).m_284406_().f_283871_, new Block[]{(Block)RailcraftBlocks.FORCE_TRACK_EMITTER.get()});
        event.register((state, level, pos, tintIndex) -> ((DyeColor)state.m_61143_(ForceTrackBlock.COLOR)).m_284406_().f_283871_, new Block[]{(Block)RailcraftBlocks.FORCE_TRACK.get()});
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)RailcraftBlocks.ABANDONED_TRACK.get()});
    }

    private static void handleParticleRegistration(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.STEAM.get(), SteamParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.SPARK.get(), SparkParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.PUMPKIN.get(), PumpkinParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.TUNING_AURA.get(), TuningAuraParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.FIRE_SPARK.get(), FireSparkParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.FORCE_SPAWN.get(), ForceSpawnParticle.Provider::new);
        event.registerSpriteSet((ParticleType)RailcraftParticleTypes.CHUNK_LOADER.get(), ChunkLoaderParticle.Provider::new);
    }

    private static void handleRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
        RailcraftEntityRenderers.register(event);
        RailcraftBlockEntityRenderers.register(event);
    }

    private static void handleRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        RailcraftLayerDefinitions.createRoots((arg_0, arg_1) -> ((EntityRenderersEvent.RegisterLayerDefinitions)event).registerLayerDefinition(arg_0, arg_1));
    }

    private static void handleKeyRegister(RegisterKeyMappingsEvent event) {
        event.register(KeyBinding.CHANGE_AURA_KEY);
    }

    @SubscribeEvent
    static void handleClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && Minecraft.m_91087_().f_91073_ != null && !Minecraft.m_91087_().m_91104_()) {
            SignalAspect.tickBlinkState();
        }
    }

    @SubscribeEvent
    static void handleRenderWorldLast(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            shuntingAuraRenderer.render(event.getPoseStack(), event.getCamera(), event.getPartialTick());
        }
    }

    @SubscribeEvent
    static void handleClientLoggedOut(ClientPlayerNetworkEvent.LoggingOut event) {
        shuntingAuraRenderer.clearCarts();
    }

    @SubscribeEvent
    static void handleClientLoggedIn(ClientPlayerNetworkEvent.LoggingIn event) {
        String qualifier;
        IModInfo modInfo = (IModInfo)ModList.get().getModFileById("railcraft").getMods().get(0);
        VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)modInfo);
        VersionChecker.Status versionStatus = result.status();
        if (versionStatus.shouldDraw()) {
            String newVersion = result.target().toString();
            String modUrl = ((URL)modInfo.getModURL().get()).toString();
            MutableComponent message = Component.m_237113_((String)"Railcraft Reborn: ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"A new version (%s) is available to download.".formatted(newVersion)).m_130938_(style -> style.m_131140_(ChatFormatting.WHITE).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, modUrl))));
            event.getPlayer().m_5661_((Component)message, false);
        }
        boolean isSnapshot = (qualifier = modInfo.getVersion().getQualifier()) != null && qualifier.equals("snapshot");
        boolean showMessageBeta = false;
        if (!FMLLoader.isProduction() || isSnapshot || showMessageBeta) {
            String type = isSnapshot ? "development" : "beta";
            String issueUrl = ((ModFileInfo)modInfo.getOwningFile()).getIssueURL().toString();
            Component message = CommonComponents.m_178396_((Component[])new Component[]{Component.m_237113_((String)"You are using a %s version of %s.".formatted(type, "Railcraft Reborn")).m_130940_(ChatFormatting.RED), Component.m_237113_((String)"- Features might be missing or only partially implemented.").m_130940_(ChatFormatting.GRAY), Component.m_237113_((String)"Bug reports are welcome at our issue tracker.").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN).m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, issueUrl))), Component.m_237113_((String)"- Sm0keySa1m0n, Edivad99").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})});
            event.getPlayer().m_5661_(message, false);
        }
    }

    @SubscribeEvent
    static void handleItemTooltip(ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        CompoundTag tag = itemStack.m_41783_();
        if (tag == null) {
            return;
        }
        if (tag.m_128441_("clickToCraft") && tag.m_128471_("clickToCraft")) {
            event.getToolTip().add(Component.m_237115_((String)Translations.Tips.CLICK_TO_CRAFT).m_130940_(ChatFormatting.YELLOW));
        }
    }

    @SubscribeEvent
    static void handleKeyInput(InputEvent.Key event) {
        if (KeyBinding.CHANGE_AURA_KEY.m_90859_()) {
            GogglesItem.changeAuraByKey(Minecraft.m_91087_().f_91074_);
        }
    }
}

