/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.data.recipes.providers;

import java.util.function.Consumer;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.data.recipes.builders.RollingRecipeBuilder;
import mods.railcraft.data.recipes.patterns.RollingRecipePattern;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;

public class RollingRecipeProvider
extends RecipeProvider {
    private RollingRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    protected void m_245200_(Consumer<FinishedRecipe> consumer) {
    }

    public static void genRecipes(Consumer<FinishedRecipe> consumer) {
        RollingRecipeProvider.misc(consumer);
        RollingRecipeProvider.buildChargeSpool(consumer);
        RollingRecipeProvider.buildTrackParts(consumer);
        RollingRecipeProvider.buildRebars(consumer);
        RollingRecipeProvider.buildElectrodes(consumer);
        RollingRecipeProvider.buildRails(consumer);
        RollingRecipeProvider.buildPlates(consumer);
    }

    private static void misc(Consumer<FinishedRecipe> consumer) {
        RollingRecipePattern.hForm(consumer, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (ItemLike)RailcraftItems.POST.variantFor(DyeColor.BLACK).get(), 16);
        RollingRecipePattern.diagonalLine(consumer, Ingredient.m_204132_(RailcraftTags.Items.STEEL_PLATE), (ItemLike)RailcraftItems.TURBINE_BLADE.get(), 1, "steel_turbine_blade");
        RollingRecipePattern.diagonalLine(consumer, Ingredient.m_204132_(RailcraftTags.Items.NICKEL_PLATE), (ItemLike)RailcraftItems.TURBINE_BLADE.get(), 1, "nickel_turbine_blade");
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.BRONZE_PLATE), (ItemLike)RailcraftItems.BUSHING_GEAR.get(), 4, "_bronze");
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.BRASS_PLATE), (ItemLike)RailcraftItems.BUSHING_GEAR.get(), 4, "_brass");
    }

    private static void buildChargeSpool(Consumer<FinishedRecipe> consumer) {
        RollingRecipeBuilder.rolled((ItemLike)RailcraftItems.CHARGE_SPOOL_LARGE.get()).pattern("a").define(Character.valueOf('a'), (TagKey<Item>)Tags.Items.STORAGE_BLOCKS_COPPER).save(consumer);
        RollingRecipeBuilder.rolled((ItemLike)RailcraftItems.CHARGE_SPOOL_SMALL.get()).pattern("a").define(Character.valueOf('a'), (TagKey<Item>)Tags.Items.INGOTS_COPPER).save(consumer);
    }

    private static void buildTrackParts(Consumer<FinishedRecipe> consumer) {
        Item trackParts = (Item)RailcraftItems.TRACK_PARTS.get();
        String name = RecipeBuilder.m_176493_((ItemLike)trackParts).m_135815_();
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("aa ").pattern("a  ").define(Character.valueOf('a'), RailcraftTags.Items.BRONZE_NUGGET).save(consumer, RailcraftConstants.rl(name + "_bronze_nugget"));
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("aa").define(Character.valueOf('a'), (TagKey<Item>)Tags.Items.NUGGETS_IRON).save(consumer, RailcraftConstants.rl(name + "_iron_nugget"));
        RollingRecipeBuilder.rolled((ItemLike)trackParts).pattern("a").define(Character.valueOf('a'), RailcraftTags.Items.STEEL_NUGGET).save(consumer, RailcraftConstants.rl(name + "_steel_nugget"));
    }

    private static void buildRebars(Consumer<FinishedRecipe> consumer) {
        RollingRecipePattern.diagonalLine(consumer, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (ItemLike)RailcraftItems.REBAR.get(), 4, "rebar_iron");
        RollingRecipePattern.diagonalLine(consumer, Ingredient.m_204132_(RailcraftTags.Items.BRONZE_INGOT), (ItemLike)RailcraftItems.REBAR.get(), 4, "rebar_bronze");
        RollingRecipePattern.diagonalLine(consumer, Ingredient.m_204132_(RailcraftTags.Items.INVAR_INGOT), (ItemLike)RailcraftItems.REBAR.get(), 6, "rebar_invar");
        RollingRecipePattern.diagonalLine(consumer, Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.REBAR.get(), 8, "rebar_steel");
    }

    private static void buildElectrodes(Consumer<FinishedRecipe> consumer) {
        RollingRecipePattern.line(consumer, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42413_, Items.f_42414_}), (ItemLike)RailcraftItems.CARBON_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.NICKEL_PLATE), (ItemLike)RailcraftItems.NICKEL_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.IRON_PLATE), (ItemLike)RailcraftItems.IRON_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.ZINC_PLATE), (ItemLike)RailcraftItems.ZINC_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.SILVER_PLATE), (ItemLike)RailcraftItems.SILVER_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.STEEL_PLATE), (ItemLike)RailcraftItems.STEEL_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.TIN_PLATE), (ItemLike)RailcraftItems.TIN_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.GOLD_PLATE), (ItemLike)RailcraftItems.GOLD_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.LEAD_PLATE), (ItemLike)RailcraftItems.LEAD_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.BRASS_PLATE), (ItemLike)RailcraftItems.BRASS_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.INVAR_PLATE), (ItemLike)RailcraftItems.INVAR_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.BRONZE_PLATE), (ItemLike)RailcraftItems.BRONZE_ELECTRODE.get(), 1);
        RollingRecipePattern.line(consumer, Ingredient.m_204132_(RailcraftTags.Items.COPPER_PLATE), (ItemLike)RailcraftItems.COPPER_ELECTRODE.get(), 1);
    }

    private static void buildRails(Consumer<FinishedRecipe> consumer) {
        RollingRecipePattern.parallelLines(consumer, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 8, "standard_rail");
        RollingRecipePattern.parallelLines(consumer, Ingredient.m_204132_(RailcraftTags.Items.BRONZE_INGOT), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 8, "bronze_rail");
        RollingRecipePattern.parallelLines(consumer, Ingredient.m_204132_(RailcraftTags.Items.INVAR_INGOT), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 12, "invar_rail");
        RollingRecipePattern.parallelLines(consumer, Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.STANDARD_RAIL.get(), 16, "steel_rail");
        RollingRecipePattern.parallelLines(consumer, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get(), 6, "copper_electric_rail");
        RollingRecipePattern.parallelLines(consumer, Ingredient.m_204132_((TagKey)Tags.Items.DUSTS_REDSTONE), Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (ItemLike)RailcraftItems.ADVANCED_RAIL.get(), 8, "advanced_rail");
        RollingRecipePattern.parallelThreeLines(consumer, Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT), Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42593_}), Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (ItemLike)RailcraftItems.HIGH_SPEED_RAIL.get(), 8, "standard_high_speed_rail");
        RollingRecipePattern.parallelThreeLines(consumer, Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT), Ingredient.m_204132_(RailcraftTags.Items.OBSIDIAN_DUST), Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.REINFORCED_RAIL.get(), 8, "steel_reinforced_rail");
        RollingRecipePattern.parallelThreeLines(consumer, Ingredient.m_204132_(RailcraftTags.Items.INVAR_INGOT), Ingredient.m_204132_(RailcraftTags.Items.OBSIDIAN_DUST), Ingredient.m_204132_(RailcraftTags.Items.INVAR_INGOT), (ItemLike)RailcraftItems.REINFORCED_RAIL.get(), 4, "invar_reinforced_rail");
        RollingRecipePattern.parallelThreeLines(consumer, Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT), Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.ELECTRIC_RAIL.get(), 12);
    }

    private static void buildPlates(Consumer<FinishedRecipe> consumer) {
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_IRON), (ItemLike)RailcraftItems.IRON_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_GOLD), (ItemLike)RailcraftItems.GOLD_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_COPPER), (ItemLike)RailcraftItems.COPPER_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.STEEL_INGOT), (ItemLike)RailcraftItems.STEEL_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.NICKEL_INGOT), (ItemLike)RailcraftItems.NICKEL_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.INVAR_INGOT), (ItemLike)RailcraftItems.INVAR_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.BRASS_INGOT), (ItemLike)RailcraftItems.BRASS_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.TIN_INGOT), (ItemLike)RailcraftItems.TIN_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.BRONZE_INGOT), (ItemLike)RailcraftItems.BRONZE_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.LEAD_INGOT), (ItemLike)RailcraftItems.LEAD_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.SILVER_INGOT), (ItemLike)RailcraftItems.SILVER_PLATE.get(), 4);
        RollingRecipePattern.square2x2(consumer, Ingredient.m_204132_(RailcraftTags.Items.ZINC_INGOT), (ItemLike)RailcraftItems.ZINC_PLATE.get(), 4);
    }
}

