/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.capability.GelCapability;
import com.legacy.structure_gel.core.capability.entity.GelEntity;
import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class UpdateGelPlayerPacket {
    protected final IGelEntity gelEntity;

    public UpdateGelPlayerPacket(IGelEntity gelEntity) {
        this.gelEntity = gelEntity;
    }

    public static void encoder(UpdateGelPlayerPacket packet, FriendlyByteBuf buff) {
        CompoundTag tag = new CompoundTag();
        packet.gelEntity.writeToNBT(tag);
        buff.m_130079_(tag);
    }

    public static UpdateGelPlayerPacket decoder(FriendlyByteBuf buff) {
        GelEntity gelEntity = new GelEntity();
        gelEntity.readFromNBT(buff.m_130260_());
        return new UpdateGelPlayerPacket(gelEntity);
    }

    public static void handler(UpdateGelPlayerPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateGelPlayerPacket.handlePacket(packet)));
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handlePacket(UpdateGelPlayerPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        GelCapability.ifPresent(mc.f_91074_, e -> e.copyFrom(packet.gelEntity));
    }
}

