/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.api.utility;

import com.google.common.collect.Lists;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FluidEffectsTooltipUtility {
    public static List<Component> getBucketEffectTooltipComponents(ItemStack pStack) {
        ArrayList<Component> componentList = new ArrayList<Component>();
        ForgeRegistries.FLUIDS.getResourceKey((Object)((BucketItem)pStack.m_41720_()).getFluid()).ifPresent(fluidResourceKey -> {
            String chemicalName = StringUtils.removeEnd((String)fluidResourceKey.m_135782_().m_135815_(), (String)"_fluid");
            AtomicReference effectList = new AtomicReference();
            ItemRegistry.getElementByName(chemicalName).ifPresent(element -> effectList.set(element.getEffects()));
            ItemRegistry.getCompoundByName(chemicalName).ifPresent(compound -> effectList.set(compound.getEffects()));
            FluidEffectsTooltipUtility.addTooltipEffects((List)effectList.get(), componentList);
        });
        return componentList;
    }

    public static void addTooltipEffects(List<MobEffectInstance> pEffects, List<Component> pTooltips) {
        ArrayList attributeModifierPairList = Lists.newArrayList();
        if (pEffects.isEmpty()) {
            pTooltips.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(" ")));
            pTooltips.add((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("chemlib.effect.on_hit", null, TranslatableContents.f_237494_)).m_130940_(ChatFormatting.UNDERLINE).m_130946_(":"));
            pTooltips.add((Component)Component.m_237115_((String)"effect.none").m_130940_(ChatFormatting.GRAY));
        } else {
            pTooltips.add((Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents(" ")));
            pTooltips.add((Component)MutableComponent.m_237204_((ComponentContents)new TranslatableContents("chemlib.effect.on_hit", null, TranslatableContents.f_237494_)).m_130940_(ChatFormatting.UNDERLINE).m_130946_(":"));
            for (MobEffectInstance effectInstance : pEffects) {
                MutableComponent mutableComponent = Component.m_237115_((String)effectInstance.m_19576_());
                MobEffect effect = effectInstance.m_19544_();
                Map attributeModifierMap = effect.m_19485_();
                if (!attributeModifierMap.isEmpty()) {
                    for (Map.Entry attributeModifierEntry : attributeModifierMap.entrySet()) {
                        AttributeModifier entryValue = (AttributeModifier)attributeModifierEntry.getValue();
                        AttributeModifier attributeModifier = new AttributeModifier(entryValue.m_22214_(), effect.m_7048_(effectInstance.m_19564_(), entryValue), entryValue.m_22217_());
                        attributeModifierPairList.add(Pair.of((Object)((Attribute)attributeModifierEntry.getKey()), (Object)attributeModifier));
                    }
                }
                mutableComponent = effectInstance.m_19564_() > 0 && effectInstance.m_19564_() <= 20 ? Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.m_237115_((String)("potion.potency." + effectInstance.m_19564_()))}) : Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.m_267641_((MobEffectInstance)effectInstance, (float)1.0f)});
                pTooltips.add((Component)mutableComponent.m_130940_(effect.m_19483_().m_19497_()));
            }
        }
        if (!attributeModifierPairList.isEmpty()) {
            for (Pair attributeModifierPair : attributeModifierPairList) {
                AttributeModifier attributeModifier = (AttributeModifier)attributeModifierPair.getValue();
                double baseModifierAmount = attributeModifier.m_22218_();
                double finalModiferAmount = attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? attributeModifier.m_22218_() : attributeModifier.m_22218_() * 100.0;
                if (baseModifierAmount > 0.0) {
                    pTooltips.add((Component)Component.m_237110_((String)String.format("attribute.modifier.plus.%s", attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(finalModiferAmount), Component.m_237115_((String)((Attribute)attributeModifierPair.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(baseModifierAmount < 0.0)) continue;
                pTooltips.add((Component)Component.m_237110_((String)String.format("attribute.modifier.take.%s", attributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(finalModiferAmount *= -1.0), Component.m_237115_((String)((Attribute)attributeModifierPair.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }
}

