/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.common.blocks;

import com.smashingmods.chemlib.api.Chemical;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class ChemicalLiquidBlock
extends LiquidBlock {
    private final String chemicalName;

    public ChemicalLiquidBlock(Supplier<? extends FlowingFluid> pFluid, String pChemicalName) {
        super(pFluid, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_280170_().m_278166_(PushReaction.DESTROY).m_278788_());
        this.chemicalName = pChemicalName;
    }

    private Optional<Chemical> getChemical() {
        AtomicReference atomicChemical = new AtomicReference();
        ItemRegistry.getElementByName(this.chemicalName).ifPresent(atomicChemical::set);
        ItemRegistry.getCompoundByName(this.chemicalName).ifPresent(atomicChemical::set);
        return Optional.of((Chemical)atomicChemical.get());
    }

    public void m_7892_(BlockState pState, Level pLevel, BlockPos pPos, Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            this.getChemical().ifPresent(chemical -> {
                for (MobEffectInstance effectInstance : chemical.getEffects()) {
                    MobEffectInstance copyEffect = new MobEffectInstance(effectInstance.m_19544_(), effectInstance.m_19557_(), effectInstance.m_19564_());
                    livingEntity.m_7292_(copyEffect);
                }
            });
        }
        super.m_7892_(pState, pLevel, pPos, pEntity);
    }
}

