/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.chemlib.datagen;

import com.smashingmods.chemlib.datagen.BlockStateGenerator;
import com.smashingmods.chemlib.datagen.BlockTagGenerator;
import com.smashingmods.chemlib.datagen.ItemModelGenerator;
import com.smashingmods.chemlib.datagen.ItemTagGenerator;
import com.smashingmods.chemlib.datagen.LocalizationGenerator;
import com.smashingmods.chemlib.datagen.LootTableGenerator;
import com.smashingmods.chemlib.datagen.RecipeGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        BlockTagGenerator blockTags = new BlockTagGenerator(packOutput, lookupProvider, fileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(packOutput, fileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(packOutput, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagGenerator(packOutput, lookupProvider, (TagsProvider<Block>)blockTags, fileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipeGenerator(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)LootTableGenerator.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new LocalizationGenerator(packOutput, "en_us"));
    }
}

