/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import mcjty.lib.blockcommands.ICommand;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketDataFromServer;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketRequestDataFromServer(ResourceKey<Level> type, BlockPos pos, String command, TypedMap params, boolean dummy) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "requestdatafromserver");

    public static PacketRequestDataFromServer create(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ResourceKey<Level> type = LevelTools.getId(buf.m_130281_());
        String command = buf.m_130136_(Short.MAX_VALUE);
        TypedMap params = TypedMapTools.readArguments(buf);
        boolean dummy = buf.readBoolean();
        return new PacketRequestDataFromServer(type, pos, command, params, dummy);
    }

    public static PacketRequestDataFromServer create(ResourceKey<Level> type, BlockPos pos, String command, TypedMap params, boolean dummy) {
        return new PacketRequestDataFromServer(type, pos, command, params, dummy);
    }

    public static PacketRequestDataFromServer create(ResourceKey<Level> type, BlockPos pos, ICommand command, TypedMap params, boolean dummy) {
        return new PacketRequestDataFromServer(type, pos, command.name(), params, dummy);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130085_(this.type.m_135782_());
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments(buf, this.params);
        buf.writeBoolean(this.dummy);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            ServerLevel world = LevelTools.getLevel(player.m_20193_(), this.type);
            if (world.m_46805_(this.pos)) {
                GenericTileEntity generic;
                TypedMap result;
                BlockEntity patt2501$temp = world.m_7702_(this.pos);
                if (patt2501$temp instanceof GenericTileEntity && (result = (generic = (GenericTileEntity)patt2501$temp).executeServerCommandWR(this.command, (Player)player, this.params)) != null) {
                    PacketDataFromServer msg = new PacketDataFromServer(this.dummy ? null : this.pos, this.command, result);
                    Networking.sendToPlayer(msg, player);
                    return;
                }
                Logging.log("Command " + this.command + " was not handled!");
            }
        }));
    }
}

