/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class TypedMapTools {
    private static Map<Type<?>, ArgumentType> typeToIndex = null;

    private static void setupTypeMapping() {
        if (typeToIndex == null) {
            typeToIndex = new HashMap();
            TypedMapTools.registerMapping(Type.STRING, ArgumentType.TYPE_STRING);
            TypedMapTools.registerMapping(Type.UUID, ArgumentType.TYPE_UUID);
            TypedMapTools.registerMapping(Type.INTEGER, ArgumentType.TYPE_INTEGER);
            TypedMapTools.registerMapping(Type.BLOCKPOS, ArgumentType.TYPE_BLOCKPOS);
            TypedMapTools.registerMapping(Type.DIMENSION_TYPE, ArgumentType.TYPE_DIMENSION_TYPE);
            TypedMapTools.registerMapping(Type.BOOLEAN, ArgumentType.TYPE_BOOLEAN);
            TypedMapTools.registerMapping(Type.DOUBLE, ArgumentType.TYPE_DOUBLE);
            TypedMapTools.registerMapping(Type.FLOAT, ArgumentType.TYPE_FLOAT);
            TypedMapTools.registerMapping(Type.ITEMSTACK, ArgumentType.TYPE_STACK);
            TypedMapTools.registerMapping(Type.LONG, ArgumentType.TYPE_LONG);
            TypedMapTools.registerMapping(Type.STRING_LIST, ArgumentType.TYPE_STRING_LIST);
            TypedMapTools.registerMapping(Type.ITEMSTACK_LIST, ArgumentType.TYPE_ITEMSTACK_LIST);
            TypedMapTools.registerMapping(Type.POS_LIST, ArgumentType.TYPE_POS_LIST);
        }
    }

    private static void registerMapping(Type<?> type, ArgumentType argumentType) {
        typeToIndex.put(type, argumentType);
    }

    private static ArgumentType getArgumentType(Type<?> type) {
        TypedMapTools.setupTypeMapping();
        return typeToIndex.get(type);
    }

    public static TypedMap readArguments(FriendlyByteBuf buf) {
        TypedMap.Builder args = TypedMap.builder();
        int size = buf.readInt();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                TypedMapTools.readArgument(buf, args::put);
            }
        }
        return args.build();
    }

    public static void readArgument(FriendlyByteBuf buf, BiConsumer<Key, Object> args) {
        String key = buf.m_130136_(Short.MAX_VALUE);
        ArgumentType type = ArgumentType.getType(buf.readByte());
        switch (type) {
            case TYPE_STRING: {
                args.accept(new Key<String>(key, Type.STRING), NetworkTools.readStringUTF8(buf));
                break;
            }
            case TYPE_UUID: {
                args.accept(new Key<UUID>(key, Type.UUID), buf.m_130259_());
                break;
            }
            case TYPE_INTEGER: {
                args.accept(new Key<Integer>(key, Type.INTEGER), buf.readInt());
                break;
            }
            case TYPE_LONG: {
                args.accept(new Key<Long>(key, Type.LONG), buf.readLong());
                break;
            }
            case TYPE_BOOLEAN: {
                args.accept(new Key<Boolean>(key, Type.BOOLEAN), buf.readBoolean());
                break;
            }
            case TYPE_DOUBLE: {
                args.accept(new Key<Double>(key, Type.DOUBLE), buf.readDouble());
                break;
            }
            case TYPE_FLOAT: {
                args.accept(new Key<Float>(key, Type.FLOAT), Float.valueOf(buf.readFloat()));
                break;
            }
            case TYPE_DIMENSION_TYPE: {
                if (buf.readBoolean()) {
                    args.accept(new Key<ResourceKey<Level>>(key, Type.DIMENSION_TYPE), LevelTools.getId(buf.m_130281_()));
                    break;
                }
                args.accept(new Key<ResourceKey<Level>>(key, Type.DIMENSION_TYPE), null);
                break;
            }
            case TYPE_BLOCKPOS: {
                if (buf.readBoolean()) {
                    args.accept(new Key<BlockPos>(key, Type.BLOCKPOS), buf.m_130135_());
                    break;
                }
                args.accept(new Key<BlockPos>(key, Type.BLOCKPOS), null);
                break;
            }
            case TYPE_STACK: {
                if (buf.readBoolean()) {
                    args.accept(new Key<ItemStack>(key, Type.ITEMSTACK), NetworkTools.readItemStack(buf));
                    break;
                }
                args.accept(new Key<ItemStack>(key, Type.ITEMSTACK), null);
                break;
            }
            case TYPE_STRING_LIST: {
                int s = buf.readInt();
                if (s == -1) {
                    args.accept(new Key<List<String>>(key, Type.STRING_LIST), null);
                    break;
                }
                ArrayList<String> list = new ArrayList<String>(s);
                for (int j = 0; j < s; ++j) {
                    list.add(NetworkTools.readStringUTF8(buf));
                }
                args.accept(new Key<List<String>>(key, Type.STRING_LIST), list);
                break;
            }
            case TYPE_ITEMSTACK_LIST: {
                int s = buf.readInt();
                if (s == -1) {
                    args.accept(new Key<List<ItemStack>>(key, Type.ITEMSTACK_LIST), null);
                    break;
                }
                ArrayList<ItemStack> list = new ArrayList<ItemStack>(s);
                for (int j = 0; j < s; ++j) {
                    list.add(NetworkTools.readItemStack(buf));
                }
                args.accept(new Key<List<ItemStack>>(key, Type.ITEMSTACK_LIST), list);
                break;
            }
            case TYPE_POS_LIST: {
                int s = buf.readInt();
                if (s == -1) {
                    args.accept(new Key<List<BlockPos>>(key, Type.POS_LIST), null);
                    break;
                }
                ArrayList<BlockPos> list = new ArrayList<BlockPos>(s);
                for (int j = 0; j < s; ++j) {
                    list.add(buf.m_130135_());
                }
                args.accept(new Key<List<BlockPos>>(key, Type.POS_LIST), list);
                break;
            }
            default: {
                throw new RuntimeException("Unsupported type for key '" + key + "'!");
            }
        }
    }

    public static void writeArguments(FriendlyByteBuf buf, TypedMap args) {
        buf.writeInt(args.size());
        for (Key<?> key : args.getKeys()) {
            TypedMapTools.writeArgument(buf, key, args.get(key));
        }
    }

    public static <T> void writeArgument(FriendlyByteBuf buf, Key<T> key, T value) {
        buf.m_130070_(key.name());
        ArgumentType argumentType = TypedMapTools.getArgumentType(key.type());
        buf.writeByte(argumentType.ordinal());
        switch (argumentType) {
            case TYPE_STRING: {
                NetworkTools.writeStringUTF8(buf, (String)value);
                break;
            }
            case TYPE_UUID: {
                buf.m_130077_((UUID)value);
                break;
            }
            case TYPE_INTEGER: {
                buf.writeInt(((Integer)value).intValue());
                break;
            }
            case TYPE_DIMENSION_TYPE: {
                ResourceKey type = (ResourceKey)value;
                if (type != null) {
                    buf.writeBoolean(true);
                    buf.m_130085_(type.m_135782_());
                    break;
                }
                buf.writeBoolean(false);
                break;
            }
            case TYPE_BLOCKPOS: {
                BlockPos pos = (BlockPos)value;
                if (pos != null) {
                    buf.writeBoolean(true);
                    buf.m_130064_(pos);
                    break;
                }
                buf.writeBoolean(false);
                break;
            }
            case TYPE_BOOLEAN: {
                buf.writeBoolean(((Boolean)value).booleanValue());
                break;
            }
            case TYPE_DOUBLE: {
                buf.writeDouble(((Double)value).doubleValue());
                break;
            }
            case TYPE_FLOAT: {
                buf.writeFloat(((Float)value).floatValue());
                break;
            }
            case TYPE_STACK: {
                ItemStack stack = (ItemStack)value;
                if (stack != null) {
                    buf.writeBoolean(true);
                    NetworkTools.writeItemStack(buf, stack);
                    break;
                }
                buf.writeBoolean(false);
                break;
            }
            case TYPE_LONG: {
                buf.writeLong(((Long)value).longValue());
                break;
            }
            case TYPE_STRING_LIST: {
                List list = (List)value;
                if (list != null) {
                    buf.writeInt(list.size());
                    for (String s : list) {
                        NetworkTools.writeStringUTF8(buf, s);
                    }
                    break;
                }
                buf.writeInt(-1);
                break;
            }
            case TYPE_ITEMSTACK_LIST: {
                List list = (List)value;
                if (list != null) {
                    buf.writeInt(list.size());
                    for (ItemStack s : list) {
                        NetworkTools.writeItemStack(buf, s);
                    }
                    break;
                }
                buf.writeInt(-1);
                break;
            }
            case TYPE_POS_LIST: {
                List list = (List)value;
                if (list != null) {
                    buf.writeInt(list.size());
                    for (BlockPos s : list) {
                        buf.m_130064_(s);
                    }
                    break;
                }
                buf.writeInt(-1);
            }
        }
    }

    static enum ArgumentType {
        TYPE_STRING(0),
        TYPE_INTEGER(1),
        TYPE_BLOCKPOS(2),
        TYPE_BOOLEAN(3),
        TYPE_DOUBLE(4),
        TYPE_STACK(5),
        TYPE_LONG(6),
        TYPE_STRING_LIST(7),
        TYPE_ITEMSTACK_LIST(8),
        TYPE_POS_LIST(9),
        TYPE_UUID(10),
        TYPE_DIMENSION_TYPE(11),
        TYPE_FLOAT(12);

        private final int index;
        private static final Map<Integer, ArgumentType> mapping;

        private ArgumentType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static ArgumentType getType(int index) {
            return mapping.get(index);
        }

        static {
            mapping = new HashMap<Integer, ArgumentType>();
            for (ArgumentType type : ArgumentType.values()) {
                mapping.put(type.index, type);
            }
        }
    }
}

