/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.registry.ModTriggers;

public record SMessagePlayerPreference(PlayerPreference playerPreference, boolean isLogin) {
    static SMessagePlayerPreference fromBytes(FriendlyByteBuf buf) {
        return new SMessagePlayerPreference(PlayerPreference.fromBytes(buf), buf.readBoolean());
    }

    static void toBytes(SMessagePlayerPreference msg, FriendlyByteBuf buf) {
        PlayerPreference.toBytes(msg.playerPreference, buf);
        buf.writeBoolean(msg.isLogin);
    }

    public static class Handler {
        static void handle(final SMessagePlayerPreference message, Supplier<NetworkEvent.Context> contextSupplier) {
            final NetworkEvent.Context ctx = contextSupplier.get();
            if (Helper.isPacketToServer(ctx)) {
                ctx.enqueueWork(new Runnable(){

                    @Override
                    public void run() {
                        ServerPlayer player = ctx.getSender();
                        if (player != null) {
                            PlayerPreference oldPlayerPreference = PlayerPreference.get(player);
                            PlayerPreference.set(player, message.playerPreference);
                            if (!message.isLogin && !message.playerPreference.hasSameFavoriteGrave(oldPlayerPreference)) {
                                ModTriggers.CHOOSE_GRAVE_TYPE.trigger(player);
                            }
                        }
                    }
                });
            }
            ctx.setPacketHandled(true);
        }
    }
}

