/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.common.item.base.IHUDItem;

public class ItemVectorRuler
extends Item
implements IHUDItem {
    private static final String TAG_SRC_X = "srcX";
    private static final String TAG_SRC_Y = "srcY";
    private static final String TAG_SRC_Z = "srcZ";
    private static final String TAG_DST_X = "dstX";
    private static final String TAG_DST_Y = "dstY";
    private static final String TAG_DST_Z = "dstZ";

    public ItemVectorRuler(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        BlockPos pos = ctx.m_8083_();
        ItemStack stack = ctx.m_43723_().m_21120_(ctx.m_43724_());
        if (!stack.m_41784_().m_128441_(TAG_SRC_Y) || ctx.m_43723_().m_6144_()) {
            stack.m_41784_().m_128405_(TAG_SRC_X, pos.m_123341_());
            stack.m_41784_().m_128405_(TAG_SRC_Y, pos.m_123342_());
            stack.m_41784_().m_128405_(TAG_SRC_Z, pos.m_123343_());
            stack.m_41749_(TAG_DST_Y);
        } else {
            stack.m_41784_().m_128405_(TAG_DST_X, pos.m_123341_());
            stack.m_41784_().m_128405_(TAG_DST_Y, pos.m_123342_());
            stack.m_41784_().m_128405_(TAG_DST_Z, pos.m_123343_());
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237113_((String)this.getVector(stack).toString()));
    }

    public Vector3 getVector(ItemStack stack) {
        int srcX = stack.m_41784_().m_128451_(TAG_SRC_X);
        int srcY = stack.m_41784_().m_128451_(TAG_SRC_Y);
        int srcZ = stack.m_41784_().m_128451_(TAG_SRC_Z);
        if (!stack.m_41784_().m_128441_(TAG_DST_Y)) {
            return new Vector3(srcX, srcY, srcZ);
        }
        int dstX = stack.m_41784_().m_128451_(TAG_DST_X);
        int dstY = stack.m_41784_().m_128451_(TAG_DST_Y);
        int dstZ = stack.m_41784_().m_128451_(TAG_DST_Z);
        return new Vector3(dstX - srcX, dstY - srcY, dstZ - srcZ);
    }

    public static Vector3 getRulerVector(Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemVectorRuler)) continue;
            return ((ItemVectorRuler)stack.m_41720_()).getVector(stack);
        }
        return Vector3.zero;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawHUD(GuiGraphics graphics, float partTicks, int screenWidth, int screenHeight, ItemStack stack) {
        String s = this.getVector(stack).toString();
        Font font = Minecraft.m_91087_().f_91062_;
        int w = font.m_92895_(s);
        graphics.drawString(font, s, (float)screenWidth / 2.0f - (float)w / 2.0f, (float)screenHeight / 2.0f + 10.0f, -1, false);
    }
}

