/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.entity.EntitySpellCircle;

public class PieceTrickBreakLoop
extends PieceTrick {
    SpellParam<Number> valueParam;

    public PieceTrickBreakLoop(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.valueParam = new ParamNumber("psi.spellparam.number", SpellParam.BLUE, false, false);
        this.addParam(this.valueParam);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        double value = this.getParamValue(context, this.valueParam).doubleValue();
        if (Math.abs(value) < 1.0) {
            if (context.focalPoint != context.caster) {
                if (context.focalPoint instanceof EntitySpellCircle) {
                    EntitySpellCircle circle = (EntitySpellCircle)context.focalPoint;
                    CompoundTag circleNBT = new CompoundTag();
                    circle.m_7380_(circleNBT);
                    circleNBT.m_128405_("timesCast", 20);
                    circleNBT.m_128405_("timesAlive", 100);
                    circle.m_20258_(circleNBT);
                } else {
                    context.focalPoint.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            } else {
                if (!context.tool.m_41619_() && context.tool.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).isPresent()) {
                    ISocketable socketableCap = (ISocketable)context.tool.getCapability(PsiAPI.SOCKETABLE_CAPABILITY).orElseThrow(NullPointerException::new);
                    socketableCap.setSelectedSlot(socketableCap.getLastSlot() + 1);
                }
                if (context.castFrom == PlayerDataHandler.get((Player)context.caster).loopcastHand) {
                    PlayerDataHandler.PlayerData data = PlayerDataHandler.get(context.caster);
                    data.stopLoopcast();
                }
            }
        }
        return null;
    }
}

