/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.StatLabel;
import vazkii.psi.api.spell.param.ParamNumber;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;
import vazkii.psi.common.block.BlockConjured;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.block.tile.TileConjured;

public class PieceTrickConjureBlock
extends PieceTrick {
    SpellParam<Vector3> position;
    SpellParam<Number> time;

    public PieceTrickConjureBlock(Spell spell) {
        super(spell);
        this.setStatLabel(EnumSpellStat.POTENCY, new StatLabel(15.0));
        this.setStatLabel(EnumSpellStat.COST, new StatLabel(20.0));
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", SpellParam.BLUE, false, false);
        this.addParam(this.position);
        this.time = new ParamNumber("psi.spellparam.time", SpellParam.RED, true, false);
        this.addParam(this.time);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        this.addStats(meta);
    }

    public void addStats(SpellMetadata meta) throws SpellCompilationException {
        meta.addStat(EnumSpellStat.POTENCY, 15);
        meta.addStat(EnumSpellStat.COST, 20);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        Vector3 positionVal = this.getParamValue(context, this.position);
        Number timeVal = this.getParamValue(context, this.time);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = positionVal.toBlockPos();
        Level world = context.focalPoint.m_20193_();
        if (!world.m_7966_(context.caster, pos)) {
            return null;
        }
        PieceTrickConjureBlock.conjure(context, timeVal, pos, world, this.messWithState(ModBlocks.conjured.m_49966_()));
        return null;
    }

    public static void conjure(SpellContext context, @Nullable Number timeVal, BlockPos pos, Level world, BlockState state) {
        if (world.m_8055_(pos).m_60734_() != state.m_60734_() && PieceTrickConjureBlock.conjure(world, pos, context.caster, state)) {
            if (timeVal != null && timeVal.intValue() > 0) {
                int val = timeVal.intValue();
                world.m_186460_(pos, state.m_60734_(), val);
            }
            BlockEntity tile = world.m_7702_(pos);
            ItemStack cad = PsiAPI.getPlayerCAD(context.caster);
            if (tile instanceof TileConjured && !cad.m_41619_()) {
                ((TileConjured)tile).colorizer = ((ICAD)cad.m_41720_()).getComponentInSlot(cad, EnumCADComponent.DYE);
            }
        }
    }

    public static boolean conjure(Level world, BlockPos pos, Player player, BlockState state) {
        if (!world.m_46805_(pos) || !world.m_7966_(player, pos)) {
            return false;
        }
        BlockState inWorld = world.m_8055_(pos);
        if (inWorld.m_60795_() || inWorld.m_247087_()) {
            return world.m_46597_(pos, state);
        }
        return false;
    }

    public BlockState messWithState(BlockState state) {
        return (BlockState)state.m_61124_((Property)BlockConjured.SOLID, (Comparable)Boolean.valueOf(true));
    }
}

