/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.pylons.network;

import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import net.permutated.pylons.Pylons;
import net.permutated.pylons.machines.base.AbstractPylonTile;

public class PacketButtonClicked {
    private final ButtonType buttonType;
    private final BlockPos blockPos;

    public PacketButtonClicked(ButtonType buttonType, BlockPos blockPos) {
        this.buttonType = buttonType;
        this.blockPos = blockPos;
    }

    public PacketButtonClicked(FriendlyByteBuf buffer) {
        this.buttonType = (ButtonType)buffer.m_130066_(ButtonType.class);
        this.blockPos = buffer.m_130135_();
    }

    public void toBytes(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)this.buttonType);
        buffer.m_130064_(this.blockPos);
    }

    public static void handle(PacketButtonClicked event, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockEntity be;
            ServerLevel serverLevel;
            Level patt1426$temp;
            Optional<ServerPlayer> player = Optional.ofNullable(((NetworkEvent.Context)ctx.get()).getSender());
            Optional<Level> world = player.map(Entity::m_20193_);
            if (player.isPresent() && (patt1426$temp = world.get()) instanceof ServerLevel && (serverLevel = (ServerLevel)patt1426$temp).m_46749_(event.blockPos) && (be = serverLevel.m_7702_(event.blockPos)) instanceof AbstractPylonTile) {
                AbstractPylonTile pylonTile = (AbstractPylonTile)be;
                switch (event.buttonType) {
                    case RANGE: {
                        pylonTile.handleRangePacket();
                        break;
                    }
                    case WORK: {
                        pylonTile.handleWorkPacket();
                        break;
                    }
                    default: {
                        Pylons.LOGGER.error("PacketButtonClicked called with invalid button type!");
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum ButtonType {
        RANGE,
        WORK;

    }
}

