/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.dyenamics.common.recipes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cy.jdkdigital.dyenamics.common.items.DyenamicDyeItem;
import cy.jdkdigital.dyenamics.core.init.RecipeSerializerInit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.Tags;

public class DyenamicFireworkStarRecipe
extends CustomRecipe {
    private static final Ingredient SHAPE_INGREDIENT = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42613_, Items.f_42402_, Items.f_42587_, Items.f_42678_, Items.f_42679_, Items.f_42682_, Items.f_42680_, Items.f_42683_, Items.f_42681_, Items.f_260451_});
    private static final Map<Item, FireworkRocketItem.Shape> SHAPE_BY_ITEM = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Items.f_42613_, FireworkRocketItem.Shape.LARGE_BALL);
        map.put(Items.f_42402_, FireworkRocketItem.Shape.BURST);
        map.put(Items.f_42587_, FireworkRocketItem.Shape.STAR);
        map.put(Items.f_42678_, FireworkRocketItem.Shape.CREEPER);
        map.put(Items.f_42679_, FireworkRocketItem.Shape.CREEPER);
        map.put(Items.f_42682_, FireworkRocketItem.Shape.CREEPER);
        map.put(Items.f_42680_, FireworkRocketItem.Shape.CREEPER);
        map.put(Items.f_42683_, FireworkRocketItem.Shape.CREEPER);
        map.put(Items.f_42681_, FireworkRocketItem.Shape.CREEPER);
        map.put(Items.f_260451_, FireworkRocketItem.Shape.CREEPER);
    });

    public DyenamicFireworkStarRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pInv, Level pLevel) {
        boolean hasShapeIngredient = false;
        boolean hasFlickerIngredient = false;
        boolean hasTrailIngredient = false;
        boolean hasGunpowder = false;
        boolean hasDye = false;
        for (int i = 0; i < pInv.m_6643_(); ++i) {
            ItemStack itemstack = pInv.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            if (SHAPE_INGREDIENT.test(itemstack)) {
                if (hasShapeIngredient) {
                    return false;
                }
                hasShapeIngredient = true;
                continue;
            }
            if (itemstack.m_204117_(Tags.Items.DUSTS_GLOWSTONE)) {
                if (hasFlickerIngredient) {
                    return false;
                }
                hasFlickerIngredient = true;
                continue;
            }
            if (itemstack.m_204117_(Tags.Items.GEMS_DIAMOND)) {
                if (hasTrailIngredient) {
                    return false;
                }
                hasTrailIngredient = true;
                continue;
            }
            if (itemstack.m_204117_(Tags.Items.GUNPOWDER)) {
                if (hasGunpowder) {
                    return false;
                }
                hasGunpowder = true;
                continue;
            }
            if (!itemstack.m_204117_(Tags.Items.DYES)) {
                return false;
            }
            hasDye = true;
        }
        return hasGunpowder && hasDye;
    }

    public ItemStack assemble(CraftingContainer pContainer, RegistryAccess pRegistryAccess) {
        ItemStack result = new ItemStack((ItemLike)Items.f_42689_);
        CompoundTag compoundtag = result.m_41698_("Explosion");
        FireworkRocketItem.Shape shape = FireworkRocketItem.Shape.SMALL_BALL;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack inputStack = pContainer.m_8020_(i);
            if (inputStack.m_41619_()) continue;
            if (SHAPE_INGREDIENT.test(inputStack)) {
                shape = SHAPE_BY_ITEM.get(inputStack.m_41720_());
                continue;
            }
            if (inputStack.m_204117_(Tags.Items.DUSTS_GLOWSTONE)) {
                compoundtag.m_128379_("Flicker", true);
                continue;
            }
            if (inputStack.m_204117_(Tags.Items.GEMS_DIAMOND)) {
                compoundtag.m_128379_("Trail", true);
                continue;
            }
            Item item = inputStack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                list.add(dye.m_41089_().m_41070_());
                continue;
            }
            item = inputStack.m_41720_();
            if (!(item instanceof DyenamicDyeItem)) continue;
            DyenamicDyeItem dye = (DyenamicDyeItem)item;
            list.add(dye.getDyeColor().getFireworkColor());
        }
        compoundtag.m_128408_("Colors", (List)list);
        compoundtag.m_128344_("Type", (byte)shape.m_41236_());
        return result;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth * pHeight >= 2;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return new ItemStack((ItemLike)Items.f_42689_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeSerializerInit.FIREWORK_STAR.get();
    }
}

