/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.terminal;

import dan200.computercraft.shared.computer.terminal.NetworkedTerminal;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Contract;

public class TerminalState {
    private final boolean colour;
    private final int width;
    private final int height;
    private final ByteBuf buffer;

    public TerminalState(NetworkedTerminal terminal) {
        this.colour = terminal.isColour();
        this.width = terminal.getWidth();
        this.height = terminal.getHeight();
        ByteBuf buf = this.buffer = Unpooled.buffer();
        terminal.write(new FriendlyByteBuf(buf));
    }

    @Nullable
    @Contract(value="null -> null; !null -> !null")
    public static TerminalState create(@Nullable NetworkedTerminal terminal) {
        return terminal == null ? null : new TerminalState(terminal);
    }

    public TerminalState(FriendlyByteBuf buf) {
        this.colour = buf.readBoolean();
        this.width = buf.m_130242_();
        this.height = buf.m_130242_();
        int length = buf.m_130242_();
        this.buffer = buf.readBytes(length);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.colour);
        buf.m_130130_(this.width);
        buf.m_130130_(this.height);
        buf.m_130130_(this.buffer.readableBytes());
        buf.writeBytes(this.buffer, this.buffer.readerIndex(), this.buffer.readableBytes());
    }

    public int size() {
        return this.buffer.readableBytes();
    }

    public void apply(NetworkedTerminal terminal) {
        terminal.resize(this.width, this.height);
        terminal.read(new FriendlyByteBuf(this.buffer));
    }

    public NetworkedTerminal create() {
        NetworkedTerminal terminal = new NetworkedTerminal(this.width, this.height, this.colour);
        terminal.read(new FriendlyByteBuf(this.buffer));
        return terminal;
    }
}

