/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import dan200.computercraft.shared.platform.PlatformHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public final class WorldUtil {
    private static final double DROP_SPEED = 0.103365;

    public static boolean isLiquidBlock(Level world, BlockPos pos) {
        if (!world.m_46739_(pos)) {
            return false;
        }
        return world.m_8055_(pos).m_278721_();
    }

    public static boolean isVecInside(VoxelShape shape, Vec3 vec) {
        if (shape.m_83281_()) {
            return false;
        }
        AABB bb = shape.m_83215_();
        return vec.f_82479_ >= bb.f_82288_ && vec.f_82479_ <= bb.f_82291_ && vec.f_82480_ >= bb.f_82289_ && vec.f_82480_ <= bb.f_82292_ && vec.f_82481_ >= bb.f_82290_ && vec.f_82481_ <= bb.f_82293_;
    }

    public static HitResult clip(Level world, Vec3 from, Vec3 direction, double distance, @Nullable Entity source) {
        Vec3 to = from.m_82520_(direction.f_82479_ * distance, direction.f_82480_ * distance, direction.f_82481_ * distance);
        return WorldUtil.clip(world, from, to, source);
    }

    public static HitResult clip(Level world, Vec3 from, Vec3 to, @Nullable Entity source) {
        ContextlessClipContext context = source == null ? new ContextlessClipContext(world, from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE) : new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, source);
        BlockHitResult blockHit = world.m_45547_((ClipContext)context);
        double distance = blockHit.m_6662_() == HitResult.Type.MISS ? from.m_82557_(to) : blockHit.m_82450_().m_82557_(from);
        EntityHitResult entityHit = WorldUtil.getEntityHitResult(world, from, to, new AABB(from, to).m_82400_(1.0), distance, source);
        return entityHit == null ? blockHit : entityHit;
    }

    @Nullable
    private static EntityHitResult getEntityHitResult(Level level, Vec3 from, Vec3 to, AABB bounds, double distanceSq, @Nullable Entity source) {
        if (distanceSq <= 0.0) {
            return null;
        }
        double bestDistance = distanceSq;
        Entity bestEntity = null;
        Vec3 bestHit = null;
        for (Entity entity : level.m_6249_(source, bounds, WorldUtil::canCollide)) {
            Vec3 hit;
            double newDistance;
            AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
            if (aabb.m_82390_(from)) {
                bestHit = from;
                bestEntity = entity;
                break;
            }
            Optional clip = aabb.m_82371_(from, to);
            if (clip.isEmpty() || !((newDistance = from.m_82557_(hit = (Vec3)clip.get())) < bestDistance)) continue;
            bestEntity = entity;
            bestHit = hit;
            bestDistance = newDistance;
        }
        return bestEntity == null ? null : new EntityHitResult(bestEntity, bestHit);
    }

    private static boolean canCollide(Entity entity) {
        return entity != null && entity.m_6084_() && entity.m_6087_();
    }

    public static Vec3 getRayStart(Player entity) {
        return entity.m_146892_();
    }

    public static Vec3 getRayEnd(Player player) {
        double reach = PlatformHelper.get().getReachDistance(player);
        Vec3 look = player.m_20154_();
        return WorldUtil.getRayStart(player).m_82520_(look.f_82479_ * reach, look.f_82480_ * reach, look.f_82481_ * reach);
    }

    public static void dropItemStack(Level level, BlockPos pos, @Nullable Direction direction, ItemStack stack) {
        double zDir;
        double yDir;
        double xDir;
        if (direction != null) {
            xDir = direction.m_122429_();
            yDir = direction.m_122430_();
            zDir = direction.m_122431_();
        } else {
            xDir = 0.0;
            yDir = 0.0;
            zDir = 0.0;
        }
        double xPos = (double)pos.m_123341_() + 0.5 + xDir * 0.7;
        double yPos = (double)pos.m_123342_() + 0.5 + yDir * 0.7;
        double zPos = (double)pos.m_123343_() + 0.5 + zDir * 0.7;
        ItemEntity item = new ItemEntity(level, xPos, yPos, zPos, stack.m_41777_());
        double baseSpeed = level.f_46441_.m_188500_() * 0.1 + 0.2;
        item.m_20334_(level.f_46441_.m_216328_(xDir * baseSpeed, 0.103365), level.f_46441_.m_216328_(yDir * baseSpeed, 0.103365), level.f_46441_.m_216328_(zDir * baseSpeed, 0.103365));
        item.m_32060_();
        level.m_7967_((Entity)item);
    }

    private static class ContextlessClipContext
    extends ClipContext {
        private final ClipContext.Block block;

        ContextlessClipContext(Level level, Vec3 from, Vec3 to, ClipContext.Block block, ClipContext.Fluid fluid) {
            super(from, to, block, fluid, (Entity)new ItemEntity(EntityType.f_20461_, level));
            this.block = block;
        }

        public VoxelShape m_45694_(BlockState state, BlockGetter level, BlockPos pos) {
            return this.block.m_7544_(state, level, pos, CollisionContext.m_82749_());
        }
    }
}

