/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.impl;

import com.mojang.authlib.GameProfile;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftbranks.FTBRanks;
import dev.ftb.mods.ftbranks.PlayerNameFormatting;
import dev.ftb.mods.ftbranks.api.FTBRanksAPI;
import dev.ftb.mods.ftbranks.api.PermissionValue;
import dev.ftb.mods.ftbranks.api.Rank;
import dev.ftb.mods.ftbranks.api.RankCondition;
import dev.ftb.mods.ftbranks.api.RankConditionFactory;
import dev.ftb.mods.ftbranks.api.RankException;
import dev.ftb.mods.ftbranks.api.RankManager;
import dev.ftb.mods.ftbranks.api.event.RankCreatedEvent;
import dev.ftb.mods.ftbranks.api.event.RankDeletedEvent;
import dev.ftb.mods.ftbranks.api.event.RankEvent;
import dev.ftb.mods.ftbranks.api.event.RanksReloadedEvent;
import dev.ftb.mods.ftbranks.impl.FTBRanksCommandManager;
import dev.ftb.mods.ftbranks.impl.PlayerRankData;
import dev.ftb.mods.ftbranks.impl.RankCommandPredicate;
import dev.ftb.mods.ftbranks.impl.RankImpl;
import dev.ftb.mods.ftbranks.impl.condition.AlwaysActiveCondition;
import dev.ftb.mods.ftbranks.impl.condition.OPCondition;
import dev.ftb.mods.ftbranks.impl.permission.BooleanPermissionValue;
import dev.ftb.mods.ftbranks.impl.permission.NumberPermissionValue;
import dev.ftb.mods.ftbranks.impl.permission.StringPermissionValue;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RankManagerImpl
implements RankManager {
    public static final LevelResource FOLDER_NAME = new LevelResource("serverconfig/ftbranks");
    private static final Path DEFAULT_RANK_FILE = ConfigUtil.DEFAULT_CONFIG_DIR.resolve("ftbranks").resolve("ranks.snbt");
    private final MinecraftServer server;
    private final Path directory;
    private final Path rankFile;
    private final Path playerFile;
    private boolean shouldSaveRanks;
    private boolean shouldSavePlayers;
    private Map<String, RankImpl> ranks;
    private final List<Rank> sortedRanks = new ArrayList<Rank>();
    private final Map<String, RankConditionFactory> conditions = new ConcurrentHashMap<String, RankConditionFactory>();
    private Map<UUID, PlayerRankData> playerData;

    public RankManagerImpl(MinecraftServer server) {
        this.server = server;
        this.directory = server.m_129843_(FOLDER_NAME);
        this.rankFile = this.directory.resolve("ranks.snbt");
        this.playerFile = this.directory.resolve("players.snbt");
    }

    public void markRanksDirty() {
        this.shouldSaveRanks = true;
    }

    public void markPlayerDataDirty() {
        this.shouldSavePlayers = true;
    }

    @Override
    public Collection<Rank> getAllRanks() {
        return this.sortedRanks;
    }

    @Override
    public Optional<Rank> getRank(String id) {
        return Optional.ofNullable((Rank)this.ranks.get(id));
    }

    @Override
    public RankImpl createRank(String id, String name, int power) {
        this.deleteRank(id);
        RankImpl rank = RankImpl.create(this, id, name, power);
        this.ranks.put(id, rank);
        this.rebuildSortedRanks();
        this.markRanksDirty();
        ((Consumer)RankEvent.CREATED.invoker()).accept(new RankCreatedEvent(this, (Rank)rank));
        return rank;
    }

    @Override
    @Nullable
    public RankImpl deleteRank(String id) {
        RankImpl rank = this.ranks.get(id);
        if (rank != null) {
            for (PlayerRankData rankData : this.playerData.values()) {
                if (!rankData.removeRank(rank)) continue;
                this.markPlayerDataDirty();
            }
            this.ranks.remove(id);
            this.rebuildSortedRanks();
            ((Consumer)RankEvent.DELETED.invoker()).accept(new RankDeletedEvent(this, (Rank)rank));
            this.markRanksDirty();
        }
        return rank;
    }

    @Override
    public Set<Rank> getAddedRanks(GameProfile profile) {
        return this.getOrCreatePlayerData(profile).addedRanks();
    }

    @Override
    public RankCondition createCondition(Rank rank, @Nullable Tag tag) throws RankException {
        SNBTCompoundTag compoundTag = new SNBTCompoundTag();
        if (tag instanceof StringTag) {
            compoundTag.m_128359_("type", tag.m_7916_());
        } else if (tag instanceof SNBTCompoundTag) {
            SNBTCompoundTag c;
            compoundTag = c = (SNBTCompoundTag)tag;
        }
        String key = compoundTag.m_128461_("type");
        if (!this.conditions.containsKey(key)) {
            throw new IllegalArgumentException("Can't create condition from tag: '" + String.valueOf(tag) + "'");
        }
        return this.conditions.get(key).create(rank, compoundTag);
    }

    @Override
    @NotNull
    public PermissionValue getPermissionValue(ServerPlayer player, String node) {
        if (node.isEmpty() || this.sortedRanks.isEmpty()) {
            return PermissionValue.MISSING;
        }
        try {
            List<Rank> list = this.sortedRanks.stream().filter(rank -> rank.isActive(player)).collect(Collectors.toList());
            return this.getPermissionValue(this.getOrCreatePlayerData(player.m_36316_()), list, node);
        }
        catch (Exception ex) {
            FTBRanks.LOGGER.error("Error getting permission value for node " + node + "!");
            ex.printStackTrace();
            return PermissionValue.MISSING;
        }
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    private PermissionValue getPermissionValue(PlayerRankData data, List<Rank> ranks, String node) {
        if (node.isEmpty()) {
            return PermissionValue.MISSING;
        }
        PermissionValue value = data.getPermission(node);
        if (!value.isEmpty()) {
            return value;
        }
        for (Rank rank : ranks) {
            PermissionValue value1 = rank.getPermission(node);
            if (value1.isEmpty()) continue;
            return value1;
        }
        int i = node.lastIndexOf(46);
        return i == -1 ? PermissionValue.MISSING : this.getPermissionValue(data, ranks, node.substring(0, i));
    }

    public void reload() throws Exception {
        this.shouldSaveRanks = false;
        if (Files.notExists(this.rankFile, new LinkOption[0])) {
            if (Files.exists(DEFAULT_RANK_FILE, new LinkOption[0])) {
                Files.copy(DEFAULT_RANK_FILE, this.rankFile, new CopyOption[0]);
            } else {
                this.createDefaultRanks();
            }
        }
        if (Files.notExists(this.playerFile, new LinkOption[0])) {
            this.playerData = new HashMap<UUID, PlayerRankData>();
            this.markPlayerDataDirty();
            this.savePlayersNow();
        }
        LinkedHashMap<String, RankImpl> tempRanks = new LinkedHashMap<String, RankImpl>();
        SNBTCompoundTag rankFileTag = SNBT.read((Path)this.rankFile);
        if (rankFileTag != null) {
            for (String rankId : rankFileTag.m_128431_()) {
                try {
                    RankImpl rank = RankImpl.readSNBT(this, rankId, rankFileTag.getCompound(rankId));
                    tempRanks.put(rank.getId(), rank);
                }
                catch (RankException e) {
                    FTBRanks.LOGGER.error("Failed to read rank {} from SNBT: {}", (Object)rankId, (Object)e.getMessage());
                }
            }
            if (tempRanks.isEmpty()) {
                FTBRanks.LOGGER.warn("No ranks found!");
            }
        } else {
            throw new RuntimeException("ranks.snbt failed to load! check your server log for errors");
        }
        LinkedHashMap<UUID, PlayerRankData> tempPlayerData = new LinkedHashMap<UUID, PlayerRankData>();
        SNBTCompoundTag playerFileTag = SNBT.read((Path)this.playerFile);
        if (playerFileTag != null) {
            for (String key : playerFileTag.m_128431_()) {
                SNBTCompoundTag o = playerFileTag.getCompound(key);
                UUID id = UUID.fromString(key);
                PlayerRankData data = PlayerRankData.fromSNBT(this, id, o, tempRanks);
                tempPlayerData.put(id, data);
            }
        } else {
            throw new RuntimeException("players.snbt failed to load! check your server log for errors");
        }
        this.ranks = new LinkedHashMap<String, RankImpl>(tempRanks);
        this.playerData = new LinkedHashMap<UUID, PlayerRankData>(tempPlayerData);
        this.rebuildSortedRanks();
        ((Consumer)RankEvent.RELOADED.invoker()).accept(new RanksReloadedEvent(FTBRanksAPI.manager()));
        PlayerNameFormatting.refreshPlayerNames();
        FTBRanks.LOGGER.info("Loaded " + this.ranks.size() + " ranks");
    }

    private void createDefaultRanks() {
        this.ranks = new LinkedHashMap<String, RankImpl>();
        RankImpl memberRank = RankImpl.create(this, "member", "Member", 1, AlwaysActiveCondition.INSTANCE);
        this.ranks.put("member", memberRank);
        RankImpl vipRank = RankImpl.create(this, "vip", "VIP", 50);
        vipRank.setPermission("ftbranks.name_format", StringPermissionValue.of("&bVIP {name}"));
        this.ranks.put("vip", vipRank);
        RankImpl adminRank = RankImpl.create(this, "admin", "Admin", 1000, new OPCondition());
        adminRank.setPermission("ftbranks.name_format", StringPermissionValue.of("&2{name}"));
        this.ranks.put("admin", adminRank);
        this.markRanksDirty();
        this.saveRanksNow();
    }

    public void refreshReadme() throws IOException {
        ArrayList<Object> lines = new ArrayList<Object>();
        lines.add("=== FTB Ranks ===");
        lines.add("");
        lines.add("Last README file update: " + String.valueOf(new Date()));
        lines.add("Wiki: https://www.notion.so/feedthebeast/FTB-Mod-Documentation-da2e359bad2449459d58d787edda3168");
        lines.add("To refresh this file, run /ftbranks refresh_readme");
        lines.add("");
        lines.add("= All available command nodes =");
        lines.add("command");
        List<String> commandList = FTBRanksCommandManager.INSTANCE.commandMap.values().stream().map(RankCommandPredicate::getNodeName).distinct().sorted().toList();
        lines.addAll(commandList);
        Files.write(this.directory.resolve("README.txt"), lines, new OpenOption[0]);
    }

    private void rebuildSortedRanks() {
        this.sortedRanks.clear();
        this.sortedRanks.addAll(this.ranks.values().stream().sorted().toList());
    }

    PlayerRankData getOrCreatePlayerData(GameProfile profile) {
        PlayerRankData data = this.playerData.get(profile.getId());
        if (data == null) {
            data = new PlayerRankData(this, profile.getId(), profile.getName());
            this.playerData.put(profile.getId(), data);
            this.markRanksDirty();
        }
        return data;
    }

    void registerCondition(String id, RankConditionFactory conditionFactory) {
        if (this.conditions.putIfAbsent(id, conditionFactory) != null) {
            FTBRanks.LOGGER.warn("condition {} already registered - ignoring attempt to overwrite", (Object)id);
        }
    }

    void load() throws Exception {
        if (Files.notExists(this.directory, new LinkOption[0])) {
            Files.createDirectories(this.directory, new FileAttribute[0]);
        }
        if (Files.notExists(this.directory.resolve("README.txt"), new LinkOption[0])) {
            this.refreshReadme();
        }
        this.reload();
    }

    void saveRanksNow() {
        if (this.shouldSaveRanks) {
            SNBTCompoundTag tag = new SNBTCompoundTag();
            for (RankImpl rank : this.ranks.values()) {
                tag.m_128365_(rank.getId(), (Tag)rank.writeSNBT());
            }
            if (!SNBT.write((Path)this.rankFile, (CompoundTag)tag)) {
                FTBRanks.LOGGER.warn("Failed to save ranks.snbt!");
            }
            this.shouldSaveRanks = false;
        }
    }

    void savePlayersNow() {
        if (this.shouldSavePlayers) {
            SNBTCompoundTag playerTag = new SNBTCompoundTag();
            for (PlayerRankData data : this.playerData.values()) {
                playerTag.m_128365_(data.getPlayerId().toString(), (Tag)data.writeSNBT());
            }
            if (!SNBT.write((Path)this.playerFile, (CompoundTag)playerTag)) {
                FTBRanks.LOGGER.warn("Failed to save players.snbt!");
            }
            this.shouldSavePlayers = false;
        }
    }

    static PermissionValue ofTag(SNBTCompoundTag tag, String key) {
        if (tag.isBoolean(key)) {
            return BooleanPermissionValue.of(tag.m_128471_(key));
        }
        Tag v = tag.m_128423_(key);
        if (v == null || v instanceof EndTag) {
            return PermissionValue.MISSING;
        }
        if (v instanceof NumericTag) {
            return NumberPermissionValue.of(((NumericTag)v).m_8103_());
        }
        if (v instanceof StringTag) {
            return StringPermissionValue.of(v.m_7916_());
        }
        return StringPermissionValue.of(v.toString());
    }

    static SNBTCompoundTag writePermissions(Map<String, PermissionValue> map, SNBTCompoundTag res) {
        map.forEach((key, value) -> {
            if (value.isEmpty()) {
                res.putNull(key);
            } else if (value instanceof BooleanPermissionValue) {
                BooleanPermissionValue b = (BooleanPermissionValue)value;
                res.m_128379_(key, b.value);
            } else if (value instanceof StringPermissionValue) {
                StringPermissionValue s = (StringPermissionValue)value;
                res.m_128359_(key, s.value);
            } else if (value instanceof NumberPermissionValue) {
                NumberPermissionValue n = (NumberPermissionValue)value;
                res.putNumber(key, n.value);
            } else {
                res.m_128359_(key, value.asString().orElse(""));
            }
        });
        return res;
    }
}

