/*
 * Decompiled with CFR 0.152.
 */
package com.github.jarva.allthearcanistgear.common.armor;

import com.github.jarva.allthearcanistgear.common.armor.AddonArmorItem;
import com.github.jarva.allthearcanistgear.setup.config.ArmorSetConfig;
import com.github.jarva.allthearcanistgear.setup.registry.AddonItemRegistry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.RegistryObject;

public class ArcanistArmorSet {
    private final RegistryObject<Item> head;
    private final RegistryObject<Item> chest;
    private final RegistryObject<Item> legs;
    private final RegistryObject<Item> feet;
    private final String name;
    private final int tier;
    private final ArmorSetConfig config;

    public ArcanistArmorSet(ArmorSetConfig config, int tier) {
        this.config = config;
        this.name = config.name();
        this.tier = tier;
        this.feet = AddonItemRegistry.register(this.name + "_boots", () -> new AddonArmorItem(config, ArmorItem.Type.BOOTS, tier));
        this.legs = AddonItemRegistry.register(this.name + "_leggings", () -> new AddonArmorItem(config, ArmorItem.Type.LEGGINGS, tier));
        this.chest = AddonItemRegistry.register(this.name + "_robes", () -> new AddonArmorItem(config, ArmorItem.Type.CHESTPLATE, tier));
        this.head = AddonItemRegistry.register(this.name + "_hat", () -> new AddonArmorItem(config, ArmorItem.Type.HELMET, tier));
    }

    public ArmorSetConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public int getTier() {
        return this.tier;
    }

    public Item getHat() {
        return (Item)this.head.get();
    }

    public Item getChest() {
        return (Item)this.chest.get();
    }

    public Item getLegs() {
        return (Item)this.legs.get();
    }

    public Item getBoots() {
        return (Item)this.feet.get();
    }

    public Item getArmorFromSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> this.getChest();
            case EquipmentSlot.LEGS -> this.getLegs();
            case EquipmentSlot.FEET -> this.getBoots();
            case EquipmentSlot.HEAD -> this.getHat();
            default -> null;
        };
    }
}

