/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.amendments.AmendmentsClient;
import net.mehvahdjukaar.amendments.common.IBetterJukebox;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.integration.CompatObjects;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.moonlight.api.client.util.VertexUtil;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;

public class JukeboxTileRenderer
implements BlockEntityRenderer<JukeboxBlockEntity> {
    public JukeboxTileRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(JukeboxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack item = blockEntity.m_272036_();
        if (!item.m_41619_() && ((Boolean)blockEntity.m_58900_().m_61143_((Property)JukeboxBlock.f_54254_)).booleanValue()) {
            poseStack.m_85837_(0.5, 0.953125, 0.5);
            if (ClientConfigs.JUKEBOX_SPIN.get().booleanValue()) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(((IBetterJukebox)blockEntity).amendments$getRotation(partialTick)));
            }
            poseStack.m_252781_(RotHlpr.X90);
            Material material = AmendmentsClient.getRecordMaterial(item.m_41720_());
            int upLight = LevelRenderer.m_109541_((BlockAndTintGetter)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_().m_6630_(1));
            int lu = upLight & 0xFFFF;
            int lv = upLight >> 16 & 0xFFFF;
            CompoundTag tag = item.m_41783_();
            if (tag != null && item.m_41720_() == CompatObjects.ETCHED_DISC.get()) {
                VertexConsumer builder;
                int color = tag.m_128451_("DiscColor");
                if (color != 0x515151) {
                    builder = AmendmentsClient.TINTED_RECORD.m_119194_(bufferSource, RenderType::m_110452_);
                    JukeboxTileRenderer.drawColoredQuad(poseStack, builder, lu, lv, color);
                } else {
                    builder = AmendmentsClient.DEFAULT_RECORD.m_119194_(bufferSource, RenderType::m_110452_);
                    VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)-0.5f, (float)-0.5f, (float)0.5f, (float)0.5f, (int)lu, (int)lv);
                }
                CompoundTag label = tag.m_128469_("LabelColor");
                int pattern = tag.m_128451_("Pattern");
                if (!label.m_128456_() && pattern < 6) {
                    builder = AmendmentsClient.RECORD_PATTERNS.get(pattern).m_119194_(bufferSource, RenderType::m_110452_);
                    int primaryColor = label.m_128451_("Primary");
                    if (primaryColor == 0) {
                        primaryColor = -1;
                    }
                    JukeboxTileRenderer.drawColoredQuad(poseStack, builder, lu, lv, primaryColor);
                    builder = AmendmentsClient.RECORD_PATTERNS_OVERLAY.get(pattern).m_119194_(bufferSource, RenderType::m_110452_);
                    int secondaryColor = label.m_128451_("Secondary");
                    if (secondaryColor == 0) {
                        secondaryColor = -1;
                    }
                    JukeboxTileRenderer.drawColoredQuad(poseStack, builder, lu, lv, secondaryColor);
                }
            } else {
                VertexConsumer builder = material.m_119194_(bufferSource, RenderType::m_110452_);
                VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)-0.5f, (float)-0.5f, (float)0.5f, (float)0.5f, (int)lu, (int)lv);
            }
        }
    }

    private static void drawColoredQuad(PoseStack poseStack, VertexConsumer builder, int lu, int lv, int color) {
        int r = FastColor.ARGB32.m_13665_((int)color);
        int g = FastColor.ARGB32.m_13667_((int)color);
        int b = FastColor.ARGB32.m_13669_((int)color);
        VertexUtil.addQuad((VertexConsumer)builder, (PoseStack)poseStack, (float)-0.5f, (float)-0.5f, (float)0.5f, (float)0.5f, (int)r, (int)g, (int)b, (int)255, (int)lu, (int)lv);
    }
}

