/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.tile.FogProjectorTileEntity;

public class FogProjectorUpdatePacket {
    BlockPos pos;
    public float particle_fog_size = 8.0f;
    public int particle_fog_color_r = 229;
    public int particle_fog_color_g = 238;
    public int particle_fog_color_b = 229;
    public int particle_fog_color_a = 255;
    public float particle_fog_thickness = 0.07f;
    public float particle_fog_speed = 0.002f;
    public boolean particle_fog_random_x = true;
    public boolean particle_fog_random_y = true;
    public boolean particle_fog_random_z = true;
    public float particle_fog_direction_x = 0.0f;
    public float particle_fog_direction_y = 0.0f;
    public float particle_fog_direction_z = 0.0f;
    public boolean particle_fog_shaders = true;
    public int particle_fog_frequency_num = 1;
    public int particle_fog_frequency_ticks = 20;
    public float camera_fog_radius = 0.0f;
    public int camera_fog_color_r = 200;
    public int camera_fog_color_g = 200;
    public int camera_fog_color_b = 200;
    public float camera_fog_strength = 5.0f;
    public boolean camera_fog_toggle = false;

    public FogProjectorUpdatePacket() {
    }

    public FogProjectorUpdatePacket(BlockPos pos, float particle_fog_size, int particle_fog_color_r, int particle_fog_color_g, int particle_fog_color_b, int particle_fog_color_a, float particle_fog_thickness, float particle_fog_speed, boolean particle_fog_random_x, boolean particle_fog_random_y, boolean particle_fog_random_z, float particle_fog_direction_x, float particle_fog_direction_y, float particle_fog_direction_z, boolean particle_fog_shaders, int particle_fog_frequency_num, int particle_fog_frequency_ticks, float camera_fog_radius, int camera_fog_color_r, int camera_fog_color_g, int camera_fog_color_b, float camera_fog_strength, boolean camera_fog_toggle) {
        this.pos = pos;
        this.particle_fog_size = particle_fog_size;
        this.particle_fog_color_r = particle_fog_color_r;
        this.particle_fog_color_g = particle_fog_color_g;
        this.particle_fog_color_b = particle_fog_color_b;
        this.particle_fog_color_a = particle_fog_color_a;
        this.particle_fog_thickness = particle_fog_thickness;
        this.particle_fog_speed = particle_fog_speed;
        this.particle_fog_random_x = particle_fog_random_x;
        this.particle_fog_random_y = particle_fog_random_y;
        this.particle_fog_random_z = particle_fog_random_z;
        this.particle_fog_direction_x = particle_fog_direction_x;
        this.particle_fog_direction_y = particle_fog_direction_y;
        this.particle_fog_direction_z = particle_fog_direction_z;
        this.particle_fog_shaders = particle_fog_shaders;
        this.particle_fog_frequency_num = particle_fog_frequency_num;
        this.particle_fog_frequency_ticks = particle_fog_frequency_ticks;
        this.camera_fog_radius = camera_fog_radius;
        this.camera_fog_color_r = camera_fog_color_r;
        this.camera_fog_color_g = camera_fog_color_g;
        this.camera_fog_color_b = camera_fog_color_b;
        this.camera_fog_strength = camera_fog_strength;
        this.camera_fog_toggle = camera_fog_toggle;
    }

    public void fromBytes(FriendlyByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.particle_fog_size = buf.readFloat();
        this.particle_fog_color_r = buf.readInt();
        this.particle_fog_color_g = buf.readInt();
        this.particle_fog_color_b = buf.readInt();
        this.particle_fog_color_a = buf.readInt();
        this.particle_fog_thickness = buf.readFloat();
        this.particle_fog_speed = buf.readFloat();
        this.particle_fog_random_x = buf.readBoolean();
        this.particle_fog_random_y = buf.readBoolean();
        this.particle_fog_random_z = buf.readBoolean();
        this.particle_fog_direction_x = buf.readFloat();
        this.particle_fog_direction_y = buf.readFloat();
        this.particle_fog_direction_z = buf.readFloat();
        this.particle_fog_shaders = buf.readBoolean();
        this.particle_fog_frequency_num = buf.readInt();
        this.particle_fog_frequency_ticks = buf.readInt();
        this.camera_fog_radius = buf.readFloat();
        this.camera_fog_color_r = buf.readInt();
        this.camera_fog_color_g = buf.readInt();
        this.camera_fog_color_b = buf.readInt();
        this.camera_fog_strength = buf.readFloat();
        this.camera_fog_toggle = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        buf.writeFloat(this.particle_fog_size);
        buf.writeInt(this.particle_fog_color_r);
        buf.writeInt(this.particle_fog_color_g);
        buf.writeInt(this.particle_fog_color_b);
        buf.writeInt(this.particle_fog_color_a);
        buf.writeFloat(this.particle_fog_thickness);
        buf.writeFloat(this.particle_fog_speed);
        buf.writeBoolean(this.particle_fog_random_x);
        buf.writeBoolean(this.particle_fog_random_y);
        buf.writeBoolean(this.particle_fog_random_z);
        buf.writeFloat(this.particle_fog_direction_x);
        buf.writeFloat(this.particle_fog_direction_y);
        buf.writeFloat(this.particle_fog_direction_z);
        buf.writeBoolean(this.particle_fog_shaders);
        buf.writeInt(this.particle_fog_frequency_num);
        buf.writeInt(this.particle_fog_frequency_ticks);
        buf.writeFloat(this.camera_fog_radius);
        buf.writeInt(this.camera_fog_color_r);
        buf.writeInt(this.camera_fog_color_g);
        buf.writeInt(this.camera_fog_color_b);
        buf.writeFloat(this.camera_fog_strength);
        buf.writeBoolean(this.camera_fog_toggle);
    }

    public static void encode(FogProjectorUpdatePacket msg, FriendlyByteBuf buf) {
        msg.toBytes(buf);
    }

    public static FogProjectorUpdatePacket decode(FriendlyByteBuf buf) {
        FogProjectorUpdatePacket msg = new FogProjectorUpdatePacket();
        msg.fromBytes(buf);
        return msg;
    }

    public static void handle(final FogProjectorUpdatePacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                FogProjectorUpdatePacket.updateTileEntity(message, ((NetworkEvent.Context)context.get()).getSender().m_9236_());
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void updateTileEntity(FogProjectorUpdatePacket message, Level world) {
        FogProjectorTileEntity projector;
        if (world.m_7702_(message.pos) instanceof FogProjectorTileEntity && (projector = (FogProjectorTileEntity)world.m_7702_(message.pos)) != null) {
            projector.set_particle_fog_size(message.particle_fog_size);
            projector.set_particle_fog_color_r(message.particle_fog_color_r);
            projector.set_particle_fog_color_g(message.particle_fog_color_g);
            projector.set_particle_fog_color_b(message.particle_fog_color_b);
            projector.set_particle_fog_color_a(message.particle_fog_color_a);
            projector.set_particle_fog_thickness(message.particle_fog_thickness);
            projector.set_particle_fog_speed(message.particle_fog_speed);
            projector.set_particle_fog_random_x(message.particle_fog_random_x);
            projector.set_particle_fog_random_y(message.particle_fog_random_y);
            projector.set_particle_fog_random_z(message.particle_fog_random_z);
            projector.set_particle_fog_direction_x(message.particle_fog_direction_x);
            projector.set_particle_fog_direction_y(message.particle_fog_direction_y);
            projector.set_particle_fog_direction_z(message.particle_fog_direction_z);
            projector.set_particle_fog_shaders(message.particle_fog_shaders);
            projector.set_particle_fog_frequency_num(message.particle_fog_frequency_num);
            projector.set_particle_fog_frequency_ticks(message.particle_fog_frequency_ticks);
            projector.set_camera_fog_radius(message.camera_fog_radius);
            projector.set_camera_fog_color_r(message.camera_fog_color_r);
            projector.set_camera_fog_color_g(message.camera_fog_color_g);
            projector.set_camera_fog_color_b(message.camera_fog_color_b);
            projector.set_camera_fog_strength(message.camera_fog_strength);
            projector.set_camera_fog_toggle(message.camera_fog_toggle);
            projector.sendUpdates();
        }
    }
}

