/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.GateChainEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderGateChainEntity
extends EntityRenderer<GateChainEntity> {
    private static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");
    private static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");

    public RenderGateChainEntity(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(GateChainEntity entity) {
        return TextureAtlas.f_118259_;
    }

    public void render(GateChainEntity entity, float eyaw, float partialTicks, PoseStack matrix, MultiBufferSource buffer, int packedLight) {
    }

    public static void renderCircle(GateChainEntity entity, double x, double y, double z, PoseStack matrix, float partialTicks) {
        float prevYaw;
        matrix.m_85836_();
        matrix.m_85837_(x, y, z);
        float size = entity.getCircleSize();
        float yaw = (entity.f_19857_ + 180.0f) % 360.0f;
        float pitch = (entity.f_19858_ + 90.0f) % 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if ((prevYaw = (entity.f_19859_ + 180.0f) % 360.0f) < 0.0f) {
            prevYaw += 360.0f;
        }
        if (prevYaw - yaw > 300.0f) {
            yaw += 360.0f;
        }
        if (prevYaw - yaw < 300.0f && prevYaw - yaw > 0.0f) {
            prevYaw = yaw;
        }
        yaw = prevYaw + partialTicks * (yaw - prevYaw);
        float len = entity.lastlen + (entity.getLength() - entity.lastlen) * partialTicks;
        matrix.m_85841_(size, size, size);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(mahoujin, 0, false));
        int lightmapX = 240;
        int lightmapY = 240;
        float[] colors = entity.getColor();
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = 1.0f;
        MultiBufferSource.BufferSource buf = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer bb = buf.m_6299_((RenderType)type);
        Matrix4f m = matrix.m_85850_().m_252922_();
        if (entity.m_9236_() != null) {
            RenderUtils.rotateQ(ClientHandler.clientTickCounter, 0.0f, 1.0f, 0.0f, matrix);
        }
        bb.m_252986_(m, -0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, -0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, 0.5f, 0.0f, 0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, 0.5f, 0.0f, -0.5f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        buf.m_109912_((RenderType)type);
        matrix.m_85837_(0.0, 0.08, 0.0);
        bb = buf.m_6299_((RenderType)type);
        bb.m_252986_(m, -0.4f, 0.0f, -0.4f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, -0.4f, 0.0f, 0.4f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, 0.4f, 0.0f, 0.4f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        bb.m_252986_(m, 0.4f, 0.0f, -0.4f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lightmapX, lightmapY).m_5752_();
        buf.m_109912_((RenderType)type);
        RenderUtils.rotateQ(-ClientHandler.clientTickCounter, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-ClientHandler.clientTickCounter, 0.0f, 1.0f, 0.0f, matrix);
        CullWrappedRenderLayer type2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.runes, 0));
        RenderUtils.renderRing(matrix, (MultiBufferSource)buf, 0.0, 45.0f, 0.4f, 0.06f, 17, 240, 240, r, g, b, a, type2);
        buf.m_109912_((RenderType)type2);
        RenderUtils.rotateQ(ClientHandler.clientTickCounter, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_85837_(0.0, -0.08, 0.0);
        RenderGateChainEntity.renderChain(matrix, buf, r, g, b, a, len);
        matrix.m_85849_();
    }

    public static void renderChain(PoseStack m, MultiBufferSource.BufferSource buf, float r, float g, float b, float a, float len) {
        float radius = 0.1f;
        float linkdist = 0.04f;
        float height = 0.1f;
        float overallscale = 0.9f;
        m.m_252880_(0.0f, -len - radius, 0.0f);
        RenderGateChainEntity.renderPyramid(m, buf, r, g, b, a);
        m.m_252880_(0.0f, len + radius, 0.0f);
        int k = 0;
        float i = len - radius;
        while (i > 0.0f) {
            m.m_252880_(0.0f, -i, 0.0f);
            RenderUtils.rotateQ(90 * k, 0.0f, 1.0f, 0.0f, m);
            RenderUtils.rotateQ(90.0f, 1.0f, 0.0f, 0.0f, m);
            RenderGateChainEntity.scaleM(m, 0.55f, overallscale, overallscale, false);
            m.m_252880_(0.0f, height / 2.0f, 0.0f);
            CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(RenderUtils.runes, k));
            RenderUtils.renderRing(m, (MultiBufferSource)buf, 0.0, 90.0f, radius, height, MTConfig.CHAIN_QUALITY, 240, 240, r, g, b, a, type);
            buf.m_109912_((RenderType)type);
            m.m_252880_(0.0f, -height / 2.0f, 0.0f);
            RenderGateChainEntity.scaleM(m, 0.55f, overallscale, overallscale, true);
            RenderUtils.rotateQ(-90.0f, 1.0f, 0.0f, 0.0f, m);
            RenderUtils.rotateQ(-90 * k, 0.0f, 1.0f, 0.0f, m);
            m.m_252880_(0.0f, i, 0.0f);
            i -= 2.0f * radius * overallscale - linkdist;
            ++k;
        }
    }

    public static void renderPyramid(PoseStack stack, MultiBufferSource.BufferSource buf, float r, float g, float b, float a) {
        RenderUtils.rotateQ(180.0f, 1.0f, 0.0f, 0.0f, stack);
        RenderGateChainEntity.scaleM(stack, 0.08f, 0.15f, 0.08f, false);
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createTriangleRenderType(RenderUtils.runes, 0));
        VertexConsumer bb = buf.m_6299_((RenderType)type);
        Matrix4f m = stack.m_85850_().m_252922_();
        int lx = 240;
        int ly = 240;
        bb.m_252986_(m, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -1.0f, -1.0f, 1.0f).m_85950_(r, g, b, a).m_7421_(0.5f, 0.5f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 1.0f, -1.0f, 1.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 1.0f, -1.0f, 1.0f).m_85950_(r, g, b, a).m_7421_(0.5f, 0.5f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 1.0f, -1.0f, -1.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 1.0f, -1.0f, -1.0f).m_85950_(r, g, b, a).m_7421_(0.5f, 0.5f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -1.0f, -1.0f, -1.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -1.0f, -1.0f, -1.0f).m_85950_(r, g, b, a).m_7421_(0.5f, 0.5f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -1.0f, -1.0f, 1.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        buf.m_109912_((RenderType)type);
        CullWrappedRenderLayer type2 = new CullWrappedRenderLayer(MahoujinRenderType.createMahoujinRenderType(RenderUtils.runes, 0, false));
        bb = buf.m_6299_((RenderType)type2);
        m = stack.m_85850_().m_252922_();
        bb.m_252986_(m, 1.0f, -1.0f, 1.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, 1.0f, -1.0f, -1.0f).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -1.0f, -1.0f, -1.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(lx, ly).m_5752_();
        bb.m_252986_(m, -1.0f, -1.0f, 1.0f).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(lx, ly).m_5752_();
        buf.m_109912_((RenderType)type2);
        RenderGateChainEntity.scaleM(stack, 0.08f, 0.15f, 0.08f, true);
        RenderUtils.rotateQ(-180.0f, 1.0f, 0.0f, 0.0f, stack);
    }

    public static void scaleM(PoseStack m, float x, float y, float z, boolean unscale) {
        if (unscale) {
            m.m_85841_(1.0f / x, 1.0f / y, 1.0f / z);
        } else {
            m.m_85841_(x, y, z);
        }
    }
}

