/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.mixin.villager;

import com.almostreliable.morejs.core.Events;
import com.almostreliable.morejs.features.villager.TradeFilter;
import com.almostreliable.morejs.features.villager.TradeTypes;
import com.almostreliable.morejs.features.villager.events.FilterEnchantedTradeEventJS;
import dev.latvian.mods.kubejs.event.EventJS;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

public class VillagerTradesMixin {

    @Mixin(value={VillagerTrades.TreasureMapForEmeralds.class})
    private static class TreasureMapForEmeraldsMixin
    implements TradeFilter.Filterable {
        private TreasureMapForEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)Items.f_42616_, 64), new ItemStack((ItemLike)Items.f_42573_), TradeTypes.TreasureMapForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.EnchantBookForEmeralds.class})
    private static class EnchantBookForEmeraldsMixin
    implements TradeFilter.Filterable {
        private EnchantBookForEmeraldsMixin() {
        }

        @Redirect(method={"getOffer"}, at=@At(value="INVOKE", target="Ljava/util/stream/Stream;collect(Ljava/util/stream/Collector;)Ljava/lang/Object;"))
        private Object invokeFilterEvent(Stream<Enchantment> instance, Collector<Enchantment, ?, List<Enchantment>> arCollector, Entity entity, RandomSource randomSource) {
            if (entity instanceof AbstractVillager) {
                AbstractVillager villager = (AbstractVillager)entity;
                List enchantments = instance.collect(Collectors.toCollection(ArrayList::new));
                FilterEnchantedTradeEventJS event = new FilterEnchantedTradeEventJS(villager, randomSource, enchantments);
                Events.FILTER_ENCHANTED_BOOK_TRADE.post((EventJS)event);
                return enchantments;
            }
            return instance.collect(arCollector);
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)Items.f_42616_, 64), new ItemStack((ItemLike)Items.f_42690_), TradeTypes.EnchantBookForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.TippedArrowForItemsAndEmeralds.class})
    private static class TippedArrowForItemsAndEmeraldsMixin
    implements TradeFilter.Filterable {
        @Shadow
        @Final
        private int f_35786_;
        @Shadow
        @Final
        private Item f_35789_;
        @Shadow
        @Final
        private int f_35790_;
        @Shadow
        @Final
        private ItemStack f_35784_;
        @Shadow
        @Final
        private int f_35785_;

        private TippedArrowForItemsAndEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)Items.f_42616_, this.f_35786_), new ItemStack((ItemLike)this.f_35789_, this.f_35790_), new ItemStack((ItemLike)this.f_35784_.m_41720_(), this.f_35785_), TradeTypes.TippedArrowForItemsAndEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.EmeraldsForVillagerTypeItem.class})
    private static class EmeraldsForVillagerTypeItemMixin
    implements TradeFilter.Filterable {
        private EmeraldsForVillagerTypeItemMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_42127_), TradeTypes.EmeraldsForVillagerTypeItem);
        }
    }

    @Mixin(value={VillagerTrades.EnchantedItemForEmeralds.class})
    private static class EnchantedItemForEmeraldsMixin
    implements TradeFilter.Filterable {
        @Shadow
        @Final
        private ItemStack f_35687_;

        private EnchantedItemForEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)Items.f_42616_, 64), this.f_35687_, TradeTypes.EnchantedItemForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.SuspiciousStewForEmerald.class})
    private static class SuspiciousStewForEmeraldMixin
    implements TradeFilter.Filterable {
        private SuspiciousStewForEmeraldMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)Items.f_42616_), new ItemStack((ItemLike)Items.f_42718_), TradeTypes.SuspiciousStewForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.ItemsAndEmeraldsToItems.class})
    private static class ItemsAndEmeraldsToItemsMixin
    implements TradeFilter.Filterable {
        @Shadow
        @Final
        private int f_35710_;
        @Shadow
        @Final
        private ItemStack f_35708_;
        @Shadow
        @Final
        private ItemStack f_35711_;
        @Shadow
        @Final
        private int f_35709_;
        @Shadow
        @Final
        private int f_35712_;

        private ItemsAndEmeraldsToItemsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)Items.f_42616_, this.f_35710_), new ItemStack((ItemLike)this.f_35708_.m_41720_(), this.f_35709_), new ItemStack((ItemLike)this.f_35711_.m_41720_(), this.f_35712_), TradeTypes.ItemsAndEmeraldsToItems);
        }
    }

    @Mixin(value={VillagerTrades.ItemsForEmeralds.class})
    private static class ItemsForEmeraldsMixin
    implements TradeFilter.Filterable {
        @Shadow
        @Final
        private int f_35735_;
        @Shadow
        @Final
        private ItemStack f_35734_;
        @Shadow
        @Final
        private int f_35736_;

        private ItemsForEmeraldsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)Items.f_42616_, this.f_35735_), new ItemStack((ItemLike)this.f_35734_.m_41720_(), this.f_35736_), TradeTypes.ItemsForEmeralds);
        }
    }

    @Mixin(value={VillagerTrades.EmeraldForItems.class})
    private static class EmeraldForItemsMixin
    implements TradeFilter.Filterable {
        @Shadow
        @Final
        private Item f_35651_;
        @Shadow
        @Final
        private int f_35652_;

        private EmeraldForItemsMixin() {
        }

        @Override
        public boolean matchesTradeFilter(TradeFilter filter) {
            return filter.match(new ItemStack((ItemLike)this.f_35651_, this.f_35652_), new ItemStack((ItemLike)Items.f_42616_), TradeTypes.EmeraldForItems);
        }
    }
}

