/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.core.block.BlockContainerCabled;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public abstract class BlockEnergyBatteryBase
extends BlockContainerCabled
implements IEnergyContainerBlock {
    public BlockEnergyBatteryBase(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityEnergyBattery::new);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BlockEnergyBatteryBase.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_ENERGY_BATTERY, (BlockEntityTicker)new BlockEntityEnergyBattery.Ticker());
    }

    @Override
    public String getEneryContainerNBTName() {
        return "energy";
    }

    @Override
    public String getEneryContainerCapacityNBTName() {
        return "capacity";
    }

    public abstract boolean isCreative();

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        InteractionResult superActionResult = super.m_6227_(state, world, pos, player, hand, blockRayTraceResult);
        if (superActionResult.m_19077_()) {
            return superActionResult;
        }
        if (player.m_21120_(hand).m_41619_()) {
            return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)pos, BlockEntityEnergyBattery.class).map(tile -> {
                player.m_5661_(Helpers.getLocalizedEnergyLevel(tile.getEnergyStored(), tile.getMaxEnergyStored()), true);
                return InteractionResult.SUCCESS;
            }).orElse(InteractionResult.PASS);
        }
        return InteractionResult.PASS;
    }

    public static void fill(IEnergyStorage energyStorage) {
        int max = energyStorage.getMaxEnergyStored();
        int stored = 1;
        while (stored > 0) {
            stored = energyStorage.receiveEnergy(max, false);
        }
    }

    @Override
    public void m_6402_(Level world, BlockPos blockPos, BlockState state, LivingEntity placer, ItemStack itemStack) {
        if (!world.m_5776_()) {
            BlockEntityHelpers.get((BlockGetter)world, (BlockPos)blockPos, BlockEntityEnergyBattery.class).ifPresent(tile -> BlockEnergyBatteryBase.itemStackToTile(itemStack.m_41777_().m_41620_(1), tile));
        }
        super.m_6402_(world, blockPos, state, placer, itemStack);
    }

    public static void itemStackToTile(ItemStack itemStack, BlockEntityEnergyBattery tile) {
        itemStack.getCapability(ForgeCapabilities.ENERGY).ifPresent(energyStorage -> {
            tile.setEnergyStored(energyStorage.getEnergyStored());
            tile.setCapacity(energyStorage.getMaxEnergyStored());
        });
    }
}

