/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.client.commands;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.UtilitiXConfig;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.MapRenderer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.fml.loading.FMLPaths;

public class MapsCommand {
    private static final Path MAPS = FMLPaths.GAMEDIR.get().resolve("maps");

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"printmap").executes(MapsCommand::printmap);
    }

    private static int printmap(CommandContext<CommandSourceStack> command) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        Entity entity = source.m_81374_();
        if (!(entity instanceof Player)) {
            return 0;
        }
        Player player = (Player)entity;
        ItemStack stack = player.m_21205_();
        if (!(stack.m_41720_() instanceof MapItem)) {
            return 0;
        }
        if (MapItem.m_151131_((ItemStack)stack) == null) {
            return 0;
        }
        int mapId = MapItem.m_151131_((ItemStack)stack);
        MapItemSavedData data = MapItem.m_42853_((ItemStack)stack, (Level)player.m_9236_());
        if (data == null) {
            return 0;
        }
        MapRenderer mapRenderer = Minecraft.m_91087_().f_91063_.m_109151_();
        MapRenderer.MapInstance mapInstance = mapRenderer.m_168778_(mapId, data);
        NativeImage img = mapInstance.f_93281_.m_117991_();
        if (!MAPS.toFile().exists() && !MAPS.toFile().mkdirs()) {
            UtilitiX.getInstance().logger.warn("Could not create Maps directory: {}", (Object)MAPS);
            return 0;
        }
        if (img == null) {
            return 0;
        }
        if (UtilitiXConfig.mapScale != 1) {
            img = MapsCommand.resize(data, img, UtilitiXConfig.mapScale);
        }
        Path path = MAPS.resolve("map_" + mapId + ".png");
        try {
            img.m_85066_(path);
            player.m_213846_((Component)Component.m_237110_((String)"utilitix.map_saved", (Object[])new Object[]{path}));
            return 1;
        }
        catch (IOException e) {
            player.m_213846_((Component)Component.m_237115_((String)"message.utilitix.map_save_command"));
            UtilitiX.getInstance().logger.warn("Files to save file: {}", (Object)path, (Object)e);
            return 0;
        }
    }

    private static NativeImage resize(MapItemSavedData data, NativeImage original, int scale) {
        int size = 128 * scale;
        NativeImage img = new NativeImage(original.m_84982_() * scale, original.m_85084_() * scale, true);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                int k = j / scale + i / scale * 128;
                img.m_84988_(j, i, MapColor.m_284315_((int)data.f_77891_[k]));
            }
        }
        return img;
    }
}

