/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.core;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integratedtunnels.GeneralConfig;

public class ItemHandlerWorldEntityExportWrapper
implements IIngredientComponentStorage<ItemStack, Integer>,
BlockSource {
    private final ServerLevel world;
    private final BlockPos pos;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final int lifespan;
    private final int delayBeforePickup;
    private final Direction facing;
    private final double velocity;
    private final float yawOffset;
    private final float pitchOffset;
    private final boolean dispense;
    private final IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler;
    private static final DefaultDispenseItemBehavior DISPENSE_ITEM_DIRECTLY = new DefaultDispenseItemBehavior();

    public ItemHandlerWorldEntityExportWrapper(ServerLevel world, BlockPos pos, double offsetX, double offsetY, double offsetZ, int lifespan, int delayBeforePickup, Direction facing, double velocity, double yawOffset, double pitchOffset, boolean dispense, IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler) {
        this.world = world;
        this.pos = pos;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.lifespan = lifespan;
        this.delayBeforePickup = delayBeforePickup;
        this.facing = facing;
        this.velocity = velocity;
        this.yawOffset = (float)yawOffset;
        this.pitchOffset = (float)pitchOffset;
        this.dispense = dispense;
        this.dispenseResultHandler = dispenseResultHandler;
    }

    protected void setThrowableHeading(ItemEntity entity, double x, double y, double z, double velocity) {
        float f = Mth.m_14116_((float)((float)(x * x + y * y + z * z)));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        entity.m_20256_(new Vec3(x *= velocity, y *= velocity, z *= velocity));
        float f1 = Mth.m_14116_((float)((float)(x * x + z * z)));
        entity.f_19859_ = (float)(Mth.m_14136_((double)x, (double)z) * 57.29577951308232);
        entity.f_19860_ = (float)(Mth.m_14136_((double)y, (double)f1) * 57.29577951308232);
        entity.f_19859_ = entity.f_19859_;
        entity.f_19860_ = entity.f_19860_;
    }

    protected static void handleDispenseResult(IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler, BlockSource blockSource, ItemStack itemStack) {
        ItemStack remaining = (ItemStack)dispenseResultHandler.insert((Object)itemStack, false);
        if (!remaining.m_41619_()) {
            DISPENSE_ITEM_DIRECTLY.m_6115_(blockSource, remaining);
        }
    }

    public double m_7096_() {
        return (double)this.m_7961_().m_123341_() + this.offsetX;
    }

    public double m_7098_() {
        return (double)this.m_7961_().m_123342_() + this.offsetY;
    }

    public double m_7094_() {
        return (double)this.m_7961_().m_123343_() + this.offsetZ;
    }

    public BlockPos m_7961_() {
        return this.pos.m_121945_(this.facing.m_122424_());
    }

    public BlockState m_6414_() {
        return (BlockState)((BlockState)Blocks.f_50061_.m_49966_().m_61124_((Property)DispenserBlock.f_52660_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DispenserBlock.f_52659_, (Comparable)this.facing);
    }

    public DispenserBlockEntity getEntity() {
        return new SimulatedTileEntityDispenser(this.dispenseResultHandler, this);
    }

    public ServerLevel m_7727_() {
        return this.world;
    }

    public IngredientComponent<ItemStack, Integer> getComponent() {
        return IngredientComponent.ITEMSTACK;
    }

    public Iterator<ItemStack> iterator() {
        return Iterators.forArray((Object[])new ItemStack[0]);
    }

    public Iterator<ItemStack> iterator(@Nonnull ItemStack prototype, Integer matchCondition) {
        return this.iterator();
    }

    public long getMaxQuantity() {
        return 64L;
    }

    public ItemStack insert(@Nonnull ItemStack stack, boolean simulate) {
        if (!simulate) {
            DispenseItemBehavior behaviorDispenseItem;
            if (this.dispense && (behaviorDispenseItem = (DispenseItemBehavior)DispenserBlock.f_52661_.get(stack.m_41720_())).getClass() != DefaultDispenseItemBehavior.class) {
                ItemStack result = behaviorDispenseItem.m_6115_((BlockSource)this, stack.m_41777_());
                if (!result.m_41619_()) {
                    ItemHandlerWorldEntityExportWrapper.handleDispenseResult(this.dispenseResultHandler, this, result);
                }
                return ItemStack.f_41583_;
            }
            ItemEntity entity = new ItemEntity((Level)this.world, (double)this.pos.m_123341_() + this.offsetX, (double)this.pos.m_123342_() + this.offsetY, (double)this.pos.m_123343_() + this.offsetZ, stack.m_41777_());
            entity.lifespan = this.lifespan <= 0 ? stack.m_41720_().getEntityLifespan(stack, (Level)this.world) : this.lifespan;
            float yaw = this.facing.m_122435_() + this.yawOffset;
            float pitch = (this.facing == Direction.UP ? -90.0f : (this.facing == Direction.DOWN ? 90.0f : 0.0f)) - this.pitchOffset;
            this.setThrowableHeading(entity, -Mth.m_14031_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180))), -Mth.m_14031_((float)(pitch * ((float)Math.PI / 180))), Mth.m_14089_((float)(yaw * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pitch * ((float)Math.PI / 180))), this.velocity);
            entity.m_32010_(this.delayBeforePickup);
            this.world.m_7967_((Entity)entity);
            if (GeneralConfig.worldInteractionEvents) {
                this.world.m_46796_(1000, this.pos, 0);
                this.world.m_46796_(2000, this.pos.m_121945_(this.facing.m_122424_()), this.facing.m_122411_());
            }
        } else if (this.dispense) {
            stack = stack.m_41777_();
            stack.m_41620_(1);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extract(@Nonnull ItemStack prototype, Integer matchCondition, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public ItemStack extract(long maxQuantity, boolean simulate) {
        return ItemStack.f_41583_;
    }

    protected static class SimulatedTileEntityDispenser
    extends DispenserBlockEntity {
        private final IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler;
        private final BlockSource blockSource;

        public SimulatedTileEntityDispenser(IIngredientComponentStorage<ItemStack, Integer> dispenseResultHandler, BlockSource blockSource) {
            super(BlockPos.f_121853_, Blocks.f_50061_.m_49966_());
            this.dispenseResultHandler = dispenseResultHandler;
            this.blockSource = blockSource;
        }

        public int m_6643_() {
            return 0;
        }

        public int m_222761_(RandomSource randomSource) {
            return 0;
        }

        public boolean m_7983_() {
            return true;
        }

        public int m_59237_(ItemStack stack) {
            ItemHandlerWorldEntityExportWrapper.handleDispenseResult(this.dispenseResultHandler, this.blockSource, stack);
            return 0;
        }

        protected NonNullList<ItemStack> m_7086_() {
            return NonNullList.m_122779_();
        }
    }
}

