/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.modintegration.curios;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.modintegration.curios.Curios_Base;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class Curios_Active
extends Curios_Base {
    private static final Cache<ItemStack, LazyOptional<ICurio>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).removalListener(notification -> {
        LazyOptional optional = (LazyOptional)notification.getValue();
        if (optional != null) {
            optional.invalidate();
        }
    }).build();

    public static void init() {
        if (ICurio.class != null) {
            Curios_Base.INSTANCE = new Curios_Active();
            Curios_Base.CURIO_SCANNER = (entity, type) -> {
                ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler(entity).orElse(null);
                if (handler != null) {
                    for (Map.Entry entry : handler.getCurios().entrySet()) {
                        IDynamicStackHandler stacks = ((ICurioStacksHandler)entry.getValue()).getStacks();
                        for (int index = 0; index < stacks.getSlots(); ++index) {
                            ItemStack stack = stacks.getStackInSlot(index);
                            if (stack.m_41619_() || !type.test(stack)) continue;
                            return Pair.of((Object)String.format("curio|%s|%d", entry.getKey(), index), (Object)stack);
                        }
                    }
                }
                return null;
            };
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(ItemStack stack, Capability<T> capability, String id) {
        if (capability == CuriosCapability.ITEM) {
            switch (id) {
                case "ender_bag": 
                case "ender_pouch": {
                    LazyOptional value = (LazyOptional)CACHE.getIfPresent((Object)stack);
                    if (value == null) {
                        value = LazyOptional.of(() -> new EnderBagPouch(stack));
                        CACHE.put((Object)stack, (Object)value);
                    }
                    return value.isPresent() ? value.cast() : LazyOptional.empty();
                }
            }
        }
        return LazyOptional.empty();
    }

    private record EnderBagPouch(ItemStack stack) implements ICurio
    {
        public ItemStack getStack() {
            return this.stack;
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext context, UUID uuid) {
            Multimap multimap = super.getAttributeModifiers(context, uuid);
            CuriosApi.getCuriosHelper().addSlotModifier(multimap, context.identifier(), uuid, 1.0, AttributeModifier.Operation.ADDITION);
            return multimap;
        }

        public boolean canEquip(SlotContext context) {
            return Curios_Base.CURIO_SCANNER.apply(context.entity(), IOpenable.Type.getFor(this.stack)) == null && super.canEquip(context);
        }

        public boolean canUnequip(SlotContext context) {
            return this.stack.m_41720_() instanceof IOpenable && !IOpenable.isOpen(this.stack) && super.canUnequip(context);
        }

        public void curioTick(SlotContext context) {
            Item item = this.stack.m_41720_();
            if (item instanceof IOpenable) {
                IOpenable openable = (IOpenable)item;
                openable.iOpenableInventoryTick(this.stack, (Entity)context.entity());
            }
        }
    }
}

