/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.Screens;

import com.darkere.crashutils.Screens.CUOption;
import com.darkere.crashutils.Screens.CUScreen;
import com.darkere.crashutils.Screens.FillMany;
import com.darkere.crashutils.Screens.GuiTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;

public class CUList {
    List<CUOption> allOptions;
    List<CUOption> currentOptions = new ArrayList<CUOption>();
    private final int posX;
    private final int posY;
    private final int width;
    private final int height;
    CUScreen parent;
    private int currentOffset = 0;
    private int maxOffset;
    private boolean isEnabled;
    private final int lineHeight;
    private final int fitOnScreen = 14;
    private Consumer<List<CUOption>> sorter;
    private Consumer<CUOption> action;
    private String currentFilter;

    public CUList(List<CUOption> allOptions, int posX, int posY, int width, int height, CUScreen parent, Consumer<List<CUOption>> sorter, Consumer<CUOption> action) {
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.lineHeight = 9 + 4;
        this.fitOnScreen = 14;
        this.allOptions = allOptions;
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
        this.parent = parent;
        this.isEnabled = true;
        this.sorter = sorter;
        this.updateFilter("");
        this.action = action;
    }

    public void render(GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        if (!this.isEnabled) {
            return;
        }
        int x = this.posX;
        int y = this.posY + 1;
        ArrayList<FillMany.Text> text = new ArrayList<FillMany.Text>();
        ArrayList<FillMany.ColoredRectangle> seps = new ArrayList<FillMany.ColoredRectangle>();
        for (int j = this.currentOffset; j < this.currentOptions.size(); ++j) {
            CUOption currentOption = this.currentOptions.get(j);
            text.add(new FillMany.Text(x, y, currentOption.toString(), -1));
            seps.add(new FillMany.ColoredRectangle(x, y + this.lineHeight - 3, x + this.width, y + this.lineHeight - 2, -1));
            List<Button> buttons = currentOption.getButtons();
            for (int i = 0; i < buttons.size(); ++i) {
                Button button = buttons.get(i);
                button.m_252865_(x + this.width - currentOption.getButtonWidth(i));
                button.m_253211_(y - 2);
                button.m_88315_(guiGraphics, mx, my, partialTicks);
            }
            y += this.lineHeight;
            if (j == this.currentOffset + 14) break;
        }
        FillMany.fillMany(guiGraphics.m_280168_().m_85850_().m_252922_(), seps);
        FillMany.drawStrings(guiGraphics, Minecraft.m_91087_().f_91062_, text);
    }

    public void updateOptions(List<CUOption> options, Consumer<List<CUOption>> sorter, Consumer<CUOption> action) {
        this.allOptions = options;
        this.sorter = sorter;
        this.action = action;
        this.updateFilter(this.currentFilter);
    }

    public void updateFilter(String filter) {
        this.currentFilter = filter;
        this.currentOptions.clear();
        this.currentOptions.addAll(this.allOptions);
        this.currentOptions.removeIf(x -> x.shouldBeFilteredOut(filter));
        if (this.sorter != null) {
            this.sorter.accept(this.currentOptions);
        }
        this.recalculateMaxOffset();
    }

    private void recalculateMaxOffset() {
        this.maxOffset = Math.max(0, this.currentOptions.size() - 14);
        if (this.currentOffset > this.maxOffset) {
            this.currentOffset = this.maxOffset;
        }
    }

    public boolean scroll(double mx, double my, double delta) {
        if (!this.isEnabled) {
            return false;
        }
        if (GuiTools.inArea((int)mx, (int)my, this.posX, this.posY, this.posX + this.width, this.posY + this.height)) {
            if (this.maxOffset > 0) {
                if (delta < 0.0) {
                    if (this.currentOffset < this.maxOffset) {
                        ++this.currentOffset;
                    }
                } else if (this.currentOffset > 0) {
                    --this.currentOffset;
                }
            }
            return true;
        }
        return false;
    }

    public boolean checkClick(int mx, int my) {
        CUOption selectedOption;
        if (!this.isEnabled) {
            return false;
        }
        if (!GuiTools.inArea(mx, my, this.posX, this.posY, this.posX + this.width, this.posY + this.height)) {
            return false;
        }
        int selected = (my - this.posY) / this.lineHeight;
        try {
            selectedOption = this.currentOptions.get(selected + this.currentOffset);
        }
        catch (IndexOutOfBoundsException e) {
            return false;
        }
        if (!selectedOption.checkClick(mx, my, this.parent) && this.action != null) {
            this.action.accept(selectedOption);
        }
        return true;
    }
}

