/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.blocks.panelcells;

import com.dannyandson.tinyredstone.api.IOverlayBlockInfo;
import com.dannyandson.tinyredstone.api.IPanelCellInfoProvider;
import com.dannyandson.tinyredstone.blocks.PanelCellNeighbor;
import com.dannyandson.tinyredstone.blocks.PanelCellPos;
import com.dannyandson.tinyredstone.blocks.PanelCellSegment;
import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.PosInPanelCell;
import com.dannyandson.tinyredstone.blocks.RenderHelper;
import com.dannyandson.tinyredstone.blocks.Side;
import com.dannyandson.tinyredstone.blocks.panelcells.TinyBlock;
import com.dannyandson.tinyredstone.gui.NoteBlockGUI;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.network.PlaySound;
import com.dannyandson.tinyredstone.setup.Registration;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class NoteBlock
extends TinyBlock
implements IPanelCellInfoProvider {
    public static ResourceLocation TEXTURE_TINY_NOTE_BLOCK = new ResourceLocation("minecraft", "block/note_block");
    private static final String[] noteNames = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F"};
    private boolean powered = false;
    private int pitch = 0;
    private String instrument = "harp";

    @Override
    public void render(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, float alpha) {
        VertexConsumer builder = buffer.m_6299_((double)alpha == 1.0 ? RenderType.m_110451_() : RenderType.m_110466_());
        TextureAtlasSprite sprite = RenderHelper.getSprite(TEXTURE_TINY_NOTE_BLOCK);
        matrixStack.m_85837_(0.0, 0.0, 1.0);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, -1.0f, 0.0f);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
        matrixStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        matrixStack.m_252880_(0.0f, -1.0f, 0.0f);
        RenderHelper.drawRectangle(builder, matrixStack, 0.0f, 1.0f, 0.0f, 1.0f, sprite, combinedLight, this.color, alpha);
    }

    @Override
    public boolean neighborChanged(PanelCellPos cellPos) {
        PanelCellNeighbor rightNeighbor = cellPos.getNeighbor(Side.RIGHT);
        PanelCellNeighbor leftNeighbor = cellPos.getNeighbor(Side.LEFT);
        PanelCellNeighbor backNeighbor = cellPos.getNeighbor(Side.BACK);
        PanelCellNeighbor frontNeighbor = cellPos.getNeighbor(Side.FRONT);
        PanelCellNeighbor topNeighbor = cellPos.getNeighbor(Side.TOP);
        PanelCellNeighbor bottomNeighbor = cellPos.getNeighbor(Side.BOTTOM);
        boolean r = super.neighborChanged(cellPos);
        if (this.weakSignalStrength + this.strongSignalStrength > 0 || (frontNeighbor != null ? frontNeighbor.getWeakRsOutput() : 0) + (rightNeighbor != null ? rightNeighbor.getWeakRsOutput() : 0) + (backNeighbor != null ? backNeighbor.getWeakRsOutput() : 0) + (leftNeighbor != null ? leftNeighbor.getWeakRsOutput() : 0) + (topNeighbor != null ? topNeighbor.getWeakRsOutput() : 0) + (bottomNeighbor != null ? bottomNeighbor.getWeakRsOutput() : 0) > 0) {
            if (!this.powered) {
                this.powered = true;
                this.playNote(cellPos.getPanelTile());
                return true;
            }
        } else if (this.powered) {
            this.powered = false;
            return true;
        }
        return r;
    }

    @Override
    public boolean onBlockActivated(PanelCellPos cellPos, PanelCellSegment segmentClicked, Player player) {
        if (player.m_21205_().m_41720_() == Registration.REDSTONE_WRENCH.get()) {
            if (cellPos.getPanelTile().m_58904_().f_46443_) {
                NoteBlockGUI.open(cellPos.getPanelTile(), cellPos.getIndex(), this);
            }
        } else {
            ++this.pitch;
            if (this.pitch > 24) {
                this.pitch = 0;
            }
            this.playNote(cellPos.getPanelTile());
        }
        return false;
    }

    @Override
    public boolean hasActivation() {
        return true;
    }

    @Override
    public boolean isPushable() {
        return true;
    }

    @Override
    public CompoundTag writeNBT() {
        CompoundTag nbt = super.writeNBT();
        nbt.m_128405_("pitch", this.pitch);
        nbt.m_128359_("instrument", this.instrument);
        nbt.m_128379_("powered", this.powered);
        return nbt;
    }

    @Override
    public void readNBT(CompoundTag compoundNBT) {
        super.readNBT(compoundNBT);
        this.pitch = compoundNBT.m_128451_("pitch");
        this.instrument = compoundNBT.m_128461_("instrument");
        this.powered = compoundNBT.m_128471_("powered");
    }

    @Override
    public void addInfo(IOverlayBlockInfo overlayBlockInfo, PanelTile panelTile, PosInPanelCell pos) {
        overlayBlockInfo.addText("Instrument", Component.m_237115_((String)("tinyredstone.noteblock." + this.instrument)).getString());
        overlayBlockInfo.addText("Note", this.pitch + " (" + noteNames[this.pitch % 12] + ")");
    }

    private void playNote(PanelTile panelTile) {
        if (!panelTile.m_58904_().f_46443_) {
            BlockPos pos = panelTile.m_58899_();
            for (Player player : panelTile.m_58904_().m_6907_()) {
                if (!(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) < 256.0)) continue;
                ModNetworkHandler.sendToClient(new PlaySound(pos, "minecraft", "block.note_block." + this.instrument, 0.5f, this.pitch == 0 ? 0.5f : (float)Math.pow(2.0, ((float)this.pitch - 12.0f) / 12.0f)), (ServerPlayer)player);
            }
        }
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }
}

