/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.shrink.items;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.gigabit101.shrink.ShrinkContainer;
import net.gigabit101.shrink.api.ShrinkAPI;
import net.gigabit101.shrink.cap.EnergyStorageItemImpl;
import net.gigabit101.shrink.config.ShrinkConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class ItemShrinkingDevice
extends Item
implements MenuProvider {
    public ItemShrinkingDevice(Item.Properties properties) {
        super(properties.m_41497_(Rarity.EPIC).m_41487_(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6047_()) {
            player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                if (!iShrinkProvider.isShrunk()) {
                    if (!level.m_5776_()) {
                        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
                    }
                } else if (!level.m_5776_()) {
                    player.m_5661_((Component)Component.m_237113_((String)"Can't open while shrunk"), false);
                }
            });
        }
        if (!level.m_5776_() && player.m_6047_()) {
            player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                if (!iShrinkProvider.isShrunk() && this.canUse(stack, player)) {
                    iShrinkProvider.shrink((LivingEntity)((ServerPlayer)player));
                } else if (iShrinkProvider.isShrunk() && this.canUse(stack, player)) {
                    iShrinkProvider.deShrink((LivingEntity)((ServerPlayer)player));
                } else if (!this.canUse(stack, player) && ((Boolean)ShrinkConfig.POWER_REQUIREMENT.get()).booleanValue()) {
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Not enough power in device")), true);
                }
            });
        }
        if (level.m_5776_() && player.m_6047_()) {
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 5.0f, 0.0f);
            this.spawnParticle(level, player.m_20185_(), player.m_20186_(), player.m_20189_() - 1.0, level.f_46441_);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        AtomicReference<Float> scale = new AtomicReference<Float>(Float.valueOf(0.1f));
        player.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> scale.set(Float.valueOf(iShrinkProvider.scale())));
        if (entity instanceof LivingEntity && !entity.m_9236_().f_46443_) {
            if (entity.m_6095_().m_204039_(ShrinkAPI.SHRINK_DENYLIST)) {
                player.m_5661_((Component)Component.m_237115_((String)"shrink.deny_shrink"), false);
                return false;
            }
            entity.getCapability(ShrinkAPI.SHRINK_CAPABILITY).ifPresent(iShrinkProvider -> {
                iShrinkProvider.setScale(((Float)scale.get()).floatValue());
                if (!iShrinkProvider.isShrunk() && this.canUse(stack, player)) {
                    iShrinkProvider.shrink((LivingEntity)entity);
                } else if (iShrinkProvider.isShrunk() && this.canUse(stack, player)) {
                    iShrinkProvider.deShrink((LivingEntity)entity);
                }
                if (!this.canUse(stack, player)) {
                    player.m_5661_((Component)Component.m_237113_((String)(ChatFormatting.RED + "Not enough power in device")), true);
                }
            });
            return true;
        }
        return false;
    }

    public void spawnParticle(Level worldIn, double posX, double posY, double posZ, RandomSource rand) {
        for (int i = 0; i < 16; ++i) {
            int j = rand.m_188503_(2) * 2 - 1;
            int k = rand.m_188503_(2) * 2 - 1;
            double d0 = posX + 0.5 + 0.25 * (double)j;
            double d1 = (float)posY + (float)rand.m_188502_();
            double d2 = posZ + 0.5 + 0.25 * (double)k;
            double d3 = (float)rand.m_188502_() * (float)j;
            double d4 = ((double)rand.m_188502_() - 0.5) * 0.125;
            double d5 = (float)rand.m_188502_() * (float)k;
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123760_, d0, d1, d2, d3, d4, d5);
        }
    }

    public boolean canUse(ItemStack stack, Player playerEntity) {
        IEnergyStorage energyStorage;
        if (!((Boolean)ShrinkConfig.POWER_REQUIREMENT.get()).booleanValue()) {
            return true;
        }
        if (playerEntity.m_7500_()) {
            return true;
        }
        LazyOptional optional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (optional.isPresent() && (energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new)).getEnergyStored() >= (Integer)ShrinkConfig.POWER_COST.get()) {
            energyStorage.extractEnergy(((Integer)ShrinkConfig.POWER_COST.get()).intValue(), false);
            return true;
        }
        return false;
    }

    public boolean hasPower(ItemStack stack) {
        LazyOptional optional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return energyStorage.getEnergyStored() >= (Integer)ShrinkConfig.POWER_COST.get();
        }
        return false;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ENERGY) {
                    return LazyOptional.of(() -> new EnergyStorageItemImpl(stack, (Integer)ShrinkConfig.POWER_CAPACITY.get(), (Integer)ShrinkConfig.POWER_CAPACITY.get(), (Integer)ShrinkConfig.POWER_CAPACITY.get())).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public boolean m_142522_(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        return energy.getEnergyStored() < energy.getMaxEnergyStored();
    }

    public int m_142158_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY, null).map(e -> Math.min(13 * e.getEnergyStored() / e.getMaxEnergyStored(), 13)).orElse(0);
    }

    public int m_142159_(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.ENERGY).map(e -> Mth.m_14169_((float)(Math.max(0.0f, (float)e.getEnergyStored() / (float)e.getMaxEnergyStored()) / 3.0f), (float)1.0f, (float)1.0f)).orElse(super.m_142159_(stack));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        LazyOptional optional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            tooltip.add((Component)Component.m_237113_((String)(energyStorage.getEnergyStored() + " FE / " + energyStorage.getMaxEnergyStored() + " FE")));
        }
    }

    public Component m_5446_() {
        return Component.m_237113_((String)this.m_41467_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inventory, @NotNull Player player) {
        return new ShrinkContainer(id, inventory, null);
    }
}

